﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using FuzzTalk;
using FuzzTalk.Actions;
using FuzzTalkUI.Views;
using FuzzTalkUI.Models;


namespace FuzzTalkUI.ViewModels
{
    public class ScriptViewModel : BaseViewModel
    {
        private FuzzTalkScript _Script;
        
        public FuzzTalkScript Script
        {
        	get { return _Script; }
        	set
        	{                
        		_Script = value;

                InvokePropertyChanged("Script");

                SetActions();
        	}
        }

        private ObservableCollection<FuzzTalkActionViewModel> _InitActions = new ObservableCollection<FuzzTalkActionViewModel>();
        
        public ObservableCollection<FuzzTalkActionViewModel> InitActions
        {
        	get { return _InitActions; }
        	set
        	{                
        		_InitActions = value;
        
        		InvokePropertyChanged("InitActions");
        	}
        }

        private ObservableCollection<FuzzTalkActionViewModel> _Actions = new ObservableCollection<FuzzTalkActionViewModel>();
        
        public ObservableCollection<FuzzTalkActionViewModel> Actions
        {
        	get { return _Actions; }
        	set
        	{                
        		_Actions = value;
        
        		InvokePropertyChanged("Actions");
        	}
        }

        private ObservableCollection<FuzzTalkActionViewModel> _CleanupActions = new ObservableCollection<FuzzTalkActionViewModel>();
        
        public ObservableCollection<FuzzTalkActionViewModel> CleanupActions
        {
        	get { return _CleanupActions; }
        	set
        	{                
        		_CleanupActions = value;
        
        		InvokePropertyChanged("CleanupActions");
        	}
        }

        

        private void SetActions()
        {
            foreach (var a in new[]
            { 
                new { Actions = _Script.InitActions, ViewModels = InitActions },
                new { Actions = _Script.Actions, ViewModels = Actions },
                new { Actions = _Script.CleanupActions, ViewModels = CleanupActions },
            })
            {
                a.ViewModels.Clear();

                foreach (var a2 in a.Actions)
                    a.ViewModels.Add(new FuzzTalkActionViewModel(a2, Element, this));
            }
        }

        public ScriptViewModel(FrameworkElement Element, BaseViewModel Parent)
            : base(Element, Parent)
        {
            Init();
        }

        public ScriptViewModel(FrameworkElement Element)
            : base(Element)
        {
            Init();
        }

        private void Init()
        {
            (Element.FindName("AddActionButton") as Button).Click += 
                new RoutedEventHandler(AddActionButton_Click);
        }

        void AddActionButton_Click(object sender, RoutedEventArgs e)
        {
            var vm = new ActionPickerViewModel();

            var dialog = new Dialog()
            {
                DataContext = vm,
                Width= 250,
                Height = 140
            };

            dialog.OkayButton.Click += (_o, _e) =>
            {
                Console.Write(vm);

                var action = Activator.CreateInstance(vm.SelectedActionType) as FuzzTalkAction;
                
                Actions.Add(new FuzzTalkActionViewModel(action, Element));
            };

            dialog.ContentPresenter.Content = new ActionPicker();
            
            dialog.ShowDialog();
        }
    }
}
