﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace FuzzTalk
{
    public static class UI
    {
        public static void PrintHeader()
        {

            Console.WriteLine(
@"Fuzz Talk {0} - John Leitch http://www.autosectools.com",
                Assembly.GetEntryAssembly().GetName().Version);
        }

        public static void DisplayDirections()
        {
            Console.WriteLine(
@"
=====================================================
| Usage                                             |
=====================================================

FuzzTalk [script] [-p] [parameters]

script      specifies the script file to use
-p          lists the parameters of the script
parameters  sets the parameter values of the script


=====================================================
| Examples                                          |
=====================================================

FuzzTalk scripts\HttpFields1.xml -p

FuzzTalk scripts\HttpFields1.xml

FuzzTalk scripts\HttpFields1.xml -ProcessName HttpServer -Host myhost -Port 88
");
        }

        public static void DisplayParameters(IEnumerable<FuzzTalkScriptParameter> Parameters)
        {
            Console.WriteLine();

            var template = 
@"Name:          {0}
Description:   {1}
";
            if (!Parameters.Any())
            {
                Console.WriteLine("No parameters");
            }

            var parameters = string.Join("\r\n", Parameters.Select(x =>
                    x.DefaultValue == null ?
                        string.Format(template, x.Name, x.Description) :
                        string.Format(template + "Default value: {2}\r\n", x.Name, x.Description, 
                            x.DefaultValue))                            
                .ToArray());

            Console.WriteLine(parameters);
        }

        //public static void DisplayMessage(string Message, params object[] Arg)
        //{
        //    Console.WriteLine(Message, Arg);
        //}

        public static void DisplayError(string Error, params object[] Arg)
        {
            Console.BackgroundColor = ConsoleColor.Black;
            Console.ForegroundColor = ConsoleColor.Red;
            Console.WriteLine("\r\nError: " + Error, Arg);            
            Console.ResetColor();
        }

        private static char _currentSpinnerChar = '-';

        public static void Spinner()
        {
            //Console.ForegroundColor = ConsoleColor.Black;
            //Console.BackgroundColor = ConsoleColor.Gray;
            Console.Write("\b" + _currentSpinnerChar);            
            //Console.ResetColor();

            _currentSpinnerChar = 
                _currentSpinnerChar == '-' ? '\\' :
                _currentSpinnerChar == '\\' ? '|' :
                _currentSpinnerChar == '|' ? '/' :
                '-';
        }

        public static void ClearSpinner()
        {
            Console.Write("\b ");
        }
    }
}
