﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace FuzzTalk.DataAnalysis
{
    public class StringFinder
    {
        private byte[] _bytes;

        public byte[] Bytes
        {
            get { return _bytes; }
            set { _bytes = value; }
        }

        private int _threshholdLength = 4;

        public int ThreshholdLength
        {
            get { return _threshholdLength; }
            set { _threshholdLength = value; }
        }

        private bool _nullTerminated = false;

        public bool NullTerminated
        {
            get { return _nullTerminated; }
            set 
            {
                throw new NotImplementedException();

                _nullTerminated = value;
            }
        }

        private bool _alphaOnly = false;

        public bool AlphaOnly
        {
            get { return _alphaOnly; }
            set { _alphaOnly = value; }
        }

        public StringFinder()
        {
        }

        public StringFinder(byte[] Bytes)
        {
            _bytes = Bytes;
        }

        private bool IsPrintable(byte Value)
        {
            if (!_alphaOnly)
                return Value > 0 && Value <= 0x7F;
            else
                return (Value >= (byte)'A' && Value <= (byte)'Z') ||
                    (Value >= (byte)'a' && Value <= (byte)'z');
        }

        public StringMatch[] FindStrings()
        {
            var stringMatches = new List<StringMatch>();

            for (int i = 0; i < _bytes.Length; i++)
            {
                if (IsPrintable(_bytes[i]))
                {
                    var stringBytes = new List<byte> { _bytes[i] };

                    int j;

                    for (j = i + 1; j < _bytes.Length; j++)
                    {
                        var b = _bytes[j];

                        if (IsPrintable(b))
                            stringBytes.Add(b);
                        else
                            break;
                    }

                    if (stringBytes.Count >= _threshholdLength)
                        stringMatches.Add(new StringMatch()
                        {
                            Index = i,
                            Value = ASCIIEncoding.ASCII.GetString(stringBytes.ToArray())
                        });

                    i += stringBytes.Count;
                }
            }

            return stringMatches.ToArray();
        }
    }
}
