﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace FuzzTalk
{
    public class ActivityLog
    {
        private string _logFile;

        public string LogFile
        {
            get { return _logFile; }
            set { _logFile = value; }
        }

        private StreamWriter _writer;

        public StreamWriter Writer
        {
            get { return _writer; }
            set { _writer = value; }
        }

        public ActivityLog(string Name)
        {
            _logFile = Name + "_" + DateTime.Now.Ticks + ".log";

            _writer = File.CreateText(_logFile);
            _writer.AutoFlush = true;
        }

        public void AddEntry(string Entry)
        {
            var entry2 = Entry;

            for (int i = Entry.Length - 1; i > 0; i--)
            {
                var c = Entry[i];
                
                if (c <= 127)
                    continue;

                entry2 = entry2
                    .Remove(i, 1)
                    .Insert(i, "\\x" + ((int)c).ToString("X").PadLeft(2, '0')); 
            }

            _writer.WriteLine(entry2);
            _writer.WriteLine(new string('-', 64));
        }
    }
}
