﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace FuzzTalk.Actions
{
    public class Send : SocketAction
    {
        private string _value;

        [XmlAttribute]
        public string Value
        {
            get { return _value; }
            set 
            {
                // TODO: Move unescaping to initialization
                _value = System.Text.RegularExpressions.Regex.Unescape(value); 
            }
        }

        public override void Process(ActionInterpreter Interpreter)
        {
            try
            {
                if (Log)
                    Program.Log.AddEntry("Send:\r\n\r\n" + _value);

                var c = Interpreter.FindActionByName(Socket) as Connect;
                c.SendData(_value.GetBytes());
            }
            catch (System.Exception ex)
            {
                Program.Log.AddEntry("Send Error:\r\n\r\n" + ex);
            }            
        }
    }
}
