﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace FuzzTalk.Actions
{
    public class Disconnect : FuzzTalkAction, ISocketAction
    {
        private string _socket;

        [XmlAttribute]
        public string Socket
        {
            get { return _socket; }
            set { _socket = value; }
        }

        public override void Process(ActionInterpreter Interpreter)
        {
            var c = Interpreter.FindActionByName(_socket) as Connect;
            c.Close();

            if (Log)
                Program.Log.AddEntry("Disconnect: " + _socket);
        }
    }
}
