#define SHOW_MESSAGES
#include "stdafx.h"
#include "Debugger.h"
#include "testing.h"

#include <windows.h>
#include <iostream>
#include <fstream>
#include <sstream>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include <map>

using namespace std;

map<int, DebugInfo*> ProcessMap;

int InstructionBufferSize = 0x20;

char* ExceptionCodeToString(DWORD ExceptionCode)
{
	switch (ExceptionCode)
	{
	case EXCEPTION_ACCESS_VIOLATION: return "ACCESS_VIOLATION";
	case EXCEPTION_DATATYPE_MISALIGNMENT: return "DATATYPE_MISALIGNMENT";
	case EXCEPTION_BREAKPOINT: return "BREAKPOINT";
	case EXCEPTION_SINGLE_STEP: return "SINGLE_STEP";
	case EXCEPTION_ARRAY_BOUNDS_EXCEEDED: return "ARRAY_BOUNDS_EXCEEDED";
	case EXCEPTION_FLT_DENORMAL_OPERAND: return "FLT_DENORMAL_OPERAND";
	case EXCEPTION_FLT_DIVIDE_BY_ZERO: return "FLT_DIVIDE_BY_ZERO";
	case EXCEPTION_FLT_INEXACT_RESULT: return "FLT_INEXACT_RESULT";
	case EXCEPTION_FLT_INVALID_OPERATION: return "FLT_INVALID_OPERATION";
	case EXCEPTION_FLT_OVERFLOW: return "FLT_OVERFLOW";
	case EXCEPTION_FLT_STACK_CHECK: return "FLT_STACK_CHECK";
	case EXCEPTION_FLT_UNDERFLOW: return "FLT_UNDERFLOW";
	case EXCEPTION_INT_DIVIDE_BY_ZERO: return "INT_DIVIDE_BY_ZERO";
	case EXCEPTION_INT_OVERFLOW: return "INT_OVERFLOW";
	case EXCEPTION_PRIV_INSTRUCTION: return "PRIV_INSTRUCTION";
	case EXCEPTION_IN_PAGE_ERROR: return "IN_PAGE_ERROR";
	case EXCEPTION_ILLEGAL_INSTRUCTION: return "ILLEGAL_INSTRUCTION";
	case EXCEPTION_NONCONTINUABLE_EXCEPTION: return "NONCONTINUABLE_EXCEPTION";
	case EXCEPTION_STACK_OVERFLOW: return "STACK_OVERFLOW";
	case EXCEPTION_INVALID_DISPOSITION: return "INVALID_DISPOSITION";
	case EXCEPTION_GUARD_PAGE: return "GUARD_PAGE";
	case EXCEPTION_INVALID_HANDLE: return "INVALID_HANDLE";
	}

	return 0;	
}

static ExceptionInfo* CreateExceptionInfo(DEBUG_EVENT Event)
{
	ExceptionInfo* info = new ExceptionInfo();

	EXCEPTION_RECORD record = Event.u.Exception.ExceptionRecord;

	info->ExceptionAddress = (DWORD)record.ExceptionAddress;
	info->ExceptionCode = record.ExceptionCode;
	info->ExceptionMessage = ExceptionCodeToString(record.ExceptionCode);

	if (record.ExceptionCode == EXCEPTION_ACCESS_VIOLATION ||
		record.ExceptionCode == EXCEPTION_IN_PAGE_ERROR)
	{
		if (!record.ExceptionInformation[0])
			info->AccessViolationType = READ_ACCESS_VIOLATION;
		else if (record.ExceptionInformation[0] == 1)
			info->AccessViolationType = WRITE_ACCESS_VIOLATION;
		else if (record.ExceptionInformation[0] == 8)
			info->AccessViolationType = DEP_ACCESS_VIOLATION;
		
		info->AccessViolationAddress = record.ExceptionInformation[1];
	}	

	HANDLE hThread = OpenThread(THREAD_GET_CONTEXT, 0, Event.dwThreadId);

	info->Context.ContextFlags = CONTEXT_ALL;
	
	if (!GetThreadContext(hThread, &info->Context))
	{
		//DM_GETTHREADCONTEXT_FAILED
	}		

	CloseHandle(hThread);	

	ShowMessage("Opening Process");

	HANDLE hProcess = OpenProcess(PROCESS_VM_READ, 0, Event.dwProcessId);

	if (!hProcess)
	{
		ShowMessage("OpenProcess failed");
	}
	else
	{
		BYTE* instructionBuffer1 = new BYTE[InstructionBufferSize];

		SIZE_T bytesRead = 0;

		if (!ReadProcessMemory(hProcess, record.ExceptionAddress, instructionBuffer1,
			InstructionBufferSize, &bytesRead))
		{
			ShowMessage("ReadProcessMemory failed");
		}

		BYTE* instructionBuffer2 = new BYTE[bytesRead];

		memcpy(instructionBuffer2, instructionBuffer1, bytesRead);

		/*for (int i = 0; i < bytesRead; i++)
			instructionBuffer2[i] = instructionBuffer1[i];*/

		info->ExceptionInstructions = instructionBuffer2;
		info->ExceptionInstructionCount = bytesRead;

		ShowMessage("Memory Read");
	}

	return info;
}

void Debug(void (_stdcall *Callback)(DebuggerMessage))
{
	/*ShowPointer("Callback Pointer", Callback);*/

	while (1)
	{
		DEBUG_EVENT debugEvent;

		//ShowMessage("Waiting for event");

		WaitForDebugEvent(&debugEvent, -1);

		DWORD dwContinueStatus;

		if (debugEvent.dwDebugEventCode == EXCEPTION_DEBUG_EVENT)
		{
			/*ShowMessage("Calling callback");*/

			Callback(*new DebuggerMessage(*CreateExceptionInfo(debugEvent)));

			/*ShowMessage("Debug Message Received");*/


			dwContinueStatus = DBG_EXCEPTION_NOT_HANDLED;
		}
		else
			dwContinueStatus = DBG_CONTINUE;

		ContinueDebugEvent(debugEvent.dwProcessId, 
			debugEvent.dwThreadId, dwContinueStatus);
	}
	
}

DWORD WINAPI StartProcessThread(LPVOID lpParam)
{
	DebugInfo* _startProcess = (DebugInfo*)lpParam;

	ShowPointer("Start Process 2", _startProcess);

	/*ShowMessage(_startProcess->Path);*/

	STARTUPINFOA* pStartupInfo = new STARTUPINFOA();
	pStartupInfo->cb = sizeof STARTUPINFOA;
	PROCESS_INFORMATION* pProcessInfo = new PROCESS_INFORMATION();

	if (!CreateProcessA(0, _startProcess->Path, 0, 0, 0, DEBUG_PROCESS, 0, 0,
		pStartupInfo, pProcessInfo))
	{
		ShowMessage("CreateProcessA Failed");

		_startProcess->Callback(*new DebuggerMessage(DM_CREATEPROCESS_FAILED, 0));

		return 1;
	}
	else
		_startProcess->Callback(*new DebuggerMessage(DM_PROCESS_STARTED, 0));

	Debug(_startProcess->Callback);

	return 0;
}

extern void __cdecl StartProcess(char* Path, void (_stdcall *Callback)(DebuggerMessage), int Id) 
{	
	ShowMessage("Starting Process");
	ShowMessage("Creating DebugInfo");

	DebugInfo* _startProcess = new DebugInfo(Path, Callback, CreateEvent(0, 1, 0, 0));

	ShowMessage("Setting DebugInfo Array");

	ProcessMap[Id] = _startProcess;	

	ShowPointer("Start Process 1", _startProcess);
		
	HANDLE hThread = CreateThread(0, 0, StartProcessThread, _startProcess, 0, 0);

	WaitForSingleObject(_startProcess->Event, INFINITE);

	TerminateThread(hThread, 0);
	
	ShowMessage("Returning");

	//Sleep(30000);
}

DWORD WINAPI AttachThread(LPVOID lpParam)
{
	DebugInfo* _startProcess = (DebugInfo*)lpParam;

	if (!DebugActiveProcess(_startProcess->ProcessId))
	{
		ShowMessage("DebugActiveProcess Failed");
		//_startProcess->Callback(*new DebuggerMessage(DM_DEBUGACTIVEPROCESS_FAILED));
		//return 1;
	}

	if (!DebugSetProcessKillOnExit(0))
	{
		ShowMessage("DebugsetProcessKillOnExit Failed");
		//_startProcess->Callback(*new DebuggerMessage(DM_DEBUGSETPROCESSKILLONEXIT_FAILED));
		//return 1;
	}

	_startProcess->Callback(*new DebuggerMessage(DM_PROCESS_STARTED, 0));

	Debug(_startProcess->Callback);

	return 0;
}

extern void __cdecl Attach(int ProcessId, void (_stdcall *Callback)(DebuggerMessage), int Id) 
{
	ShowMessage("Attaching");
	ShowMessage("Creating DebugInfo");

	DebugInfo* _startProcess = new DebugInfo(ProcessId, Callback, CreateEvent(0, 1, 0, 0));

	ShowMessage("Setting DebugInfo Array");

	ProcessMap[Id] = _startProcess;		

	HANDLE hThread = CreateThread(0, 0, AttachThread, _startProcess, 0, 0);

	WaitForSingleObject(_startProcess->Event, INFINITE);

	TerminateThread(hThread, 0);

	ShowMessage("Returning");
}

extern void __cdecl Stop(int Id) 
{
	SetEvent(ProcessMap[Id]->Event);
}