#!/usr/bin/env python

import re
import os
from module import FStealerModule

class ApacheModule(FStealerModule):
	def initialize(self):
		self.apachepattern = re.compile("(.*/etc/apache2)")
		f = self.openModuleFile("signatures","r")
		self.apachesubpaths = []
		for line in f:
			self.apachesubpaths.append(line.strip())
		for subpath in self.apachesubpaths:
			self.addPath(os.path.join("/etc/apache2", subpath))

	def preGetFile(self, path):
		match = self.apachepattern.match(path)
		if match is not None:
			for subpath in self.apachesubpaths:
				self.addPath(os.path.join(match.group(0), subpath), priority=2)

module = ApacheModule
