/*
 * Decompiled with CFR 0.152.
 */
package jsyntaxpane.components;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.Token;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.components.Markers;
import jsyntaxpane.components.SyntaxComponent;
import jsyntaxpane.util.Configuration;

public class TokenMarker
implements SyntaxComponent,
CaretListener,
PropertyChangeListener {
    public static final String DEFAULT_TOKENTYPES = "IDENTIFIER, TYPE, TYPE2, TYPE3";
    public static final String PROPERTY_COLOR = "TokenMarker.Color";
    public static final String PROPERTY_TOKENTYPES = "TokenMarker.TokenTypes";
    private static final Color DEFAULT_COLOR = new Color(0xFFEE66);
    private JEditorPane pane;
    private Set<TokenType> tokenTypes = new HashSet<TokenType>();
    private Markers.SimpleMarker marker;
    private SyntaxComponent.Status status;
    private static final Logger LOG = Logger.getLogger(TokenMarker.class.getName());

    @Override
    public void caretUpdate(CaretEvent e) {
        this.markTokenAt(e.getDot());
    }

    public void markTokenAt(int pos) {
        SyntaxDocument doc = ActionUtils.getSyntaxDocument(this.pane);
        if (doc != null) {
            Token token = doc.getTokenAt(pos);
            this.removeMarkers();
            if (token != null && this.tokenTypes.contains((Object)token.type)) {
                this.addMarkers(token);
            }
        }
    }

    public void removeMarkers() {
        Markers.removeMarkers(this.pane, this.marker);
    }

    void addMarkers(Token tok) {
        SyntaxDocument sDoc = (SyntaxDocument)this.pane.getDocument();
        sDoc.readLock();
        String text = ((Object)tok.getText(sDoc)).toString();
        Iterator<Token> it = sDoc.getTokens(0, sDoc.getLength());
        while (it.hasNext()) {
            Token nextToken = it.next();
            String nextText = ((Object)nextToken.getText(sDoc)).toString();
            if (!text.equals(nextText)) continue;
            Markers.markToken(this.pane, nextToken, this.marker);
        }
        sDoc.readUnlock();
    }

    @Override
    public void config(Configuration config) {
        Color markerColor = config.getColor(PROPERTY_COLOR, DEFAULT_COLOR);
        this.marker = new Markers.SimpleMarker(markerColor);
        String types = config.getString(PROPERTY_TOKENTYPES, DEFAULT_TOKENTYPES);
        for (String type : types.split("\\s*,\\s*")) {
            try {
                TokenType tt = TokenType.valueOf(type);
                this.tokenTypes.add(tt);
            }
            catch (IllegalArgumentException e) {
                LOG.warning("Error in setting up TokenMarker  - Invalid TokenType: " + type);
            }
        }
    }

    @Override
    public void install(JEditorPane editor) {
        this.pane = editor;
        this.pane.addCaretListener(this);
        this.markTokenAt(editor.getCaretPosition());
        this.status = SyntaxComponent.Status.INSTALLING;
    }

    @Override
    public void deinstall(JEditorPane editor) {
        this.status = SyntaxComponent.Status.DEINSTALLING;
        this.removeMarkers();
        this.pane.removeCaretListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("document")) {
            this.pane.removeCaretListener(this);
            if (this.status.equals((Object)SyntaxComponent.Status.INSTALLING)) {
                this.pane.addCaretListener(this);
                this.removeMarkers();
            }
        }
    }
}

