/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class SymbolClassTag
extends Tag {
    public int[] tagIDs;
    public String[] classNames;

    public SymbolClassTag(byte[] data, int version, long pos) throws IOException {
        super(76, "SymbolClass", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        int numSymbols = sis.readUI16();
        this.tagIDs = new int[numSymbols];
        this.classNames = new String[numSymbols];
        for (int ii = 0; ii < numSymbols; ++ii) {
            int tagID = sis.readUI16();
            String className = sis.readString();
            this.tagIDs[ii] = tagID;
            this.classNames[ii] = className;
        }
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            int numSymbols = this.tagIDs.length;
            sos.writeUI16(numSymbols);
            for (int ii = 0; ii < numSymbols; ++ii) {
                sos.writeUI16(this.tagIDs[ii]);
                sos.writeString(this.classNames[ii]);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }
}

