/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.CharacterTag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class DefineVideoStreamTag
extends CharacterTag {
    public int characterID;
    public int numFrames;
    public int width;
    public int height;
    public int videoFlagsDeblocking;
    public boolean videoFlagsSmoothing;
    public int codecID;

    @Override
    public int getCharacterID() {
        return this.characterID;
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.characterID);
            sos.writeUI16(this.numFrames);
            sos.writeUI16(this.width);
            sos.writeUI16(this.height);
            sos.writeUB(4, 0L);
            sos.writeUB(3, this.videoFlagsDeblocking);
            sos.writeUB(1, this.videoFlagsSmoothing ? 1L : 0L);
            sos.writeUI8(this.codecID);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineVideoStreamTag(byte[] data, int version, long pos) throws IOException {
        super(60, "DefineVideoStream", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.characterID = sis.readUI16();
        this.numFrames = sis.readUI16();
        this.width = sis.readUI16();
        this.height = sis.readUI16();
        sis.readUB(4);
        this.videoFlagsDeblocking = (int)sis.readUB(3);
        this.videoFlagsSmoothing = sis.readUB(1) == 1L;
        this.codecID = sis.readUI8();
    }
}

