/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.BoundedTag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.types.MATRIX;
import com.jpexs.asdec.types.RECT;
import com.jpexs.asdec.types.TEXTRECORD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefineTextTag
extends CharacterTag
implements BoundedTag {
    public int characterID;
    public RECT textBounds;
    public MATRIX textMatrix;
    public int glyphBits;
    public int advanceBits;
    public List<TEXTRECORD> textRecords;

    @Override
    public int getCharacterID() {
        return this.characterID;
    }

    public DefineTextTag(int characterID, RECT textBounds, MATRIX textMatrix, int glyphBits, int advanceBits, List<TEXTRECORD> textRecords) {
        super(11, "DefineText", new byte[0], 0L);
        this.characterID = characterID;
        this.textBounds = textBounds;
        this.textMatrix = textMatrix;
        this.glyphBits = glyphBits;
        this.advanceBits = advanceBits;
        this.textRecords = textRecords;
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.characterID);
            sos.writeRECT(this.textBounds);
            sos.writeMatrix(this.textMatrix);
            sos.writeUI8(this.glyphBits);
            sos.writeUI8(this.advanceBits);
            for (TEXTRECORD tr : this.textRecords) {
                sos.writeTEXTRECORD(tr, false, this.glyphBits, this.advanceBits);
            }
            sos.writeUI8(0);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineTextTag(byte[] data, int version, long pos) throws IOException {
        super(11, "DefineText", data, pos);
        TEXTRECORD tr;
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.characterID = sis.readUI16();
        this.textBounds = sis.readRECT();
        this.textMatrix = sis.readMatrix();
        this.glyphBits = sis.readUI8();
        this.advanceBits = sis.readUI8();
        this.textRecords = new ArrayList<TEXTRECORD>();
        while ((tr = sis.readTEXTRECORD(false, this.glyphBits, this.advanceBits)) != null) {
            this.textRecords.add(tr);
        }
    }

    @Override
    public RECT getRect() {
        return this.textBounds;
    }

    @Override
    public Set<Integer> getNeededCharacters() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (TEXTRECORD tr : this.textRecords) {
            if (!tr.styleFlagsHasFont) continue;
            ret.add(tr.fontId);
        }
        return ret;
    }
}

