/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.BoundedTag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.types.MATRIX;
import com.jpexs.asdec.types.RECT;
import com.jpexs.asdec.types.TEXTRECORD;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DefineText2Tag
extends CharacterTag
implements BoundedTag {
    public int characterID;
    public RECT textBounds;
    public MATRIX textMatrix;
    public int glyphBits;
    public int advanceBits;
    public List<TEXTRECORD> textRecords;

    @Override
    public RECT getRect() {
        return this.textBounds;
    }

    @Override
    public int getCharacterID() {
        return this.characterID;
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.characterID);
            sos.writeRECT(this.textBounds);
            sos.writeMatrix(this.textMatrix);
            sos.writeUI8(this.glyphBits);
            sos.writeUI8(this.advanceBits);
            for (TEXTRECORD tr : this.textRecords) {
                sos.writeTEXTRECORD(tr, true, this.glyphBits, this.advanceBits);
            }
            sos.writeUI8(0);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineText2Tag(byte[] data, int version, long pos) throws IOException {
        super(33, "DefineText2", data, pos);
        TEXTRECORD tr;
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.characterID = sis.readUI16();
        this.textBounds = sis.readRECT();
        this.textMatrix = sis.readMatrix();
        this.glyphBits = sis.readUI8();
        this.advanceBits = sis.readUI8();
        this.textRecords = new ArrayList<TEXTRECORD>();
        while ((tr = sis.readTEXTRECORD(true, this.glyphBits, this.advanceBits)) != null) {
            this.textRecords.add(tr);
        }
    }

    @Override
    public Set<Integer> getNeededCharacters() {
        HashSet<Integer> ret = new HashSet<Integer>();
        for (TEXTRECORD tr : this.textRecords) {
            if (!tr.styleFlagsHasFont) continue;
            ret.add(tr.fontId);
        }
        return ret;
    }
}

