/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.Tag;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DefineFontInfoTag
extends Tag {
    public int fontId;
    public String fontName;
    public boolean fontFlagsSmallText;
    public boolean fontFlagsShiftJIS;
    public boolean fontFlagsANSI;
    public boolean fontFlagsItalic;
    public boolean fontFlagsBold;
    public boolean fontFlagsWideCodes;
    public List<Integer> codeTable;

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.fontId);
            sos.writeUI8(this.fontName.getBytes().length);
            sos.write(this.fontName.getBytes());
            sos.writeUB(2, 0L);
            sos.writeUB(1, this.fontFlagsSmallText ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsShiftJIS ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsANSI ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsItalic ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsBold ? 1L : 0L);
            sos.writeUB(1, this.fontFlagsWideCodes ? 1L : 0L);
            for (int code : this.codeTable) {
                if (this.fontFlagsWideCodes) {
                    sos.writeUI16(code);
                    continue;
                }
                sos.writeUI8(code);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }

    public DefineFontInfoTag(byte[] data, int version, long pos) throws IOException {
        super(13, "DefineFontInfo", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.fontId = sis.readUI16();
        int fontNameLen = sis.readUI8();
        this.fontName = new String(sis.readBytes(fontNameLen));
        sis.readUB(2);
        this.fontFlagsSmallText = sis.readUB(1) == 1L;
        this.fontFlagsShiftJIS = sis.readUB(1) == 1L;
        this.fontFlagsANSI = sis.readUB(1) == 1L;
        this.fontFlagsItalic = sis.readUB(1) == 1L;
        this.fontFlagsBold = sis.readUB(1) == 1L;
        this.fontFlagsWideCodes = sis.readUB(1) == 1L;
        this.codeTable = new ArrayList<Integer>();
        do {
            if (this.fontFlagsWideCodes) {
                this.codeTable.add(sis.readUI16());
                continue;
            }
            this.codeTable.add(sis.readUI8());
        } while (sis.available() > 0);
    }
}

