/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.tags;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.tags.base.AloneTag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.types.BITMAPDATA;
import com.jpexs.asdec.types.COLORMAPDATA;
import com.jpexs.asdec.types.RGB;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.InflaterInputStream;

public class DefineBitsLosslessTag
extends CharacterTag
implements AloneTag {
    public int characterID;
    public int bitmapFormat;
    public int bitmapWidth;
    public int bitmapHeight;
    public int bitmapColorTableSize;
    public byte[] zlibBitmapData;
    public static final int FORMAT_8BIT_COLORMAPPED = 3;
    public static final int FORMAT_15BIT_RGB = 4;
    public static final int FORMAT_24BIT_RGB = 5;
    private COLORMAPDATA colorMapData;
    private BITMAPDATA bitmapData;
    private boolean decompressed = false;

    public BufferedImage getImage() {
        BufferedImage bi = new BufferedImage(this.bitmapWidth, this.bitmapHeight, 1);
        Graphics g = bi.getGraphics();
        COLORMAPDATA colorMapData = null;
        BITMAPDATA bitmapData = null;
        if (this.bitmapFormat == 3) {
            colorMapData = this.getColorMapData();
        }
        if (this.bitmapFormat == 4 || this.bitmapFormat == 5) {
            bitmapData = this.getBitmapData();
        }
        int pos32aligned = 0;
        int pos = 0;
        for (int y = 0; y < this.bitmapHeight; ++y) {
            for (int x = 0; x < this.bitmapWidth; ++x) {
                if (this.bitmapFormat == 3) {
                    RGB color = colorMapData.colorTableRGB[colorMapData.colorMapPixelData[pos32aligned]];
                    g.setColor(new Color(color.red, color.green, color.blue));
                }
                if (this.bitmapFormat == 4) {
                    g.setColor(new Color(bitmapData.bitmapPixelDataPix15[pos].red * 8, bitmapData.bitmapPixelDataPix15[pos].green * 8, bitmapData.bitmapPixelDataPix15[pos].blue * 8));
                }
                if (this.bitmapFormat == 5) {
                    g.setColor(new Color(bitmapData.bitmapPixelDataPix24[pos].red, bitmapData.bitmapPixelDataPix24[pos].green, bitmapData.bitmapPixelDataPix24[pos].blue));
                }
                g.fillRect(x, y, 1, 1);
                ++pos32aligned;
                ++pos;
            }
            while (pos32aligned % 4 != 0) {
                ++pos32aligned;
            }
        }
        return bi;
    }

    @Override
    public int getCharacterID() {
        return this.characterID;
    }

    public COLORMAPDATA getColorMapData() {
        if (!this.decompressed) {
            this.uncompressData();
        }
        return this.colorMapData;
    }

    public BITMAPDATA getBitmapData() {
        if (!this.decompressed) {
            this.uncompressData();
        }
        return this.bitmapData;
    }

    private void uncompressData() {
        try {
            SWFInputStream sis = new SWFInputStream(new InflaterInputStream(new ByteArrayInputStream(this.zlibBitmapData)), 10);
            if (this.bitmapFormat == 3) {
                this.colorMapData = sis.readCOLORMAPDATA(this.bitmapColorTableSize, this.bitmapWidth, this.bitmapHeight);
            }
            if (this.bitmapFormat == 4 || this.bitmapFormat == 5) {
                this.bitmapData = sis.readBITMAPDATA(this.bitmapFormat, this.bitmapWidth, this.bitmapHeight);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.decompressed = true;
    }

    public DefineBitsLosslessTag(byte[] data, int version, long pos) throws IOException {
        super(20, "DefineBitsLossless", data, pos);
        SWFInputStream sis = new SWFInputStream(new ByteArrayInputStream(data), version);
        this.characterID = sis.readUI16();
        this.bitmapFormat = sis.readUI8();
        this.bitmapWidth = sis.readUI16();
        this.bitmapHeight = sis.readUI16();
        if (this.bitmapFormat == 3) {
            this.bitmapColorTableSize = sis.readUI8();
        }
        this.zlibBitmapData = sis.readBytes(sis.available());
    }

    @Override
    public byte[] getData(int version) {
        ByteArrayOutputStream baos;
        ByteArrayOutputStream os = baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(os, version);
        try {
            sos.writeUI16(this.characterID);
            sos.writeUI8(this.bitmapFormat);
            sos.writeUI16(this.bitmapWidth);
            sos.writeUI16(this.bitmapHeight);
            if (this.bitmapFormat == 3) {
                sos.writeUI8(this.bitmapColorTableSize);
            }
            sos.write(this.zlibBitmapData);
        }
        catch (IOException e) {
            // empty catch block
        }
        return baos.toByteArray();
    }
}

