/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.gui;

import com.jpexs.asdec.SWF;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.gui.ImagePanel;
import com.jpexs.asdec.tags.DefineBitsJPEG2Tag;
import com.jpexs.asdec.tags.DefineBitsJPEG3Tag;
import com.jpexs.asdec.tags.DefineBitsJPEG4Tag;
import com.jpexs.asdec.tags.DefineBitsLossless2Tag;
import com.jpexs.asdec.tags.DefineBitsLosslessTag;
import com.jpexs.asdec.tags.DefineBitsTag;
import com.jpexs.asdec.tags.DefineMorphShape2Tag;
import com.jpexs.asdec.tags.DefineMorphShapeTag;
import com.jpexs.asdec.tags.DefineTextTag;
import com.jpexs.asdec.tags.EndTag;
import com.jpexs.asdec.tags.JPEGTablesTag;
import com.jpexs.asdec.tags.PlaceObject2Tag;
import com.jpexs.asdec.tags.SetBackgroundColorTag;
import com.jpexs.asdec.tags.ShowFrameTag;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.tags.base.AloneTag;
import com.jpexs.asdec.tags.base.BoundedTag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.tags.base.Container;
import com.jpexs.asdec.tags.base.FontTag;
import com.jpexs.asdec.types.GLYPHENTRY;
import com.jpexs.asdec.types.MATRIX;
import com.jpexs.asdec.types.RECT;
import com.jpexs.asdec.types.RGB;
import com.jpexs.asdec.types.TEXTRECORD;
import com.jpexs.flashplayer.FlashPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TagPanel
extends JPanel
implements ListSelectionListener {
    public JList tagList;
    public FlashPanel flashPanel;
    public JPanel displayPanel;
    public ImagePanel imagePanel;
    private SWF swf;
    static final String CARDFLASHPANEL = "Flash card";
    static final String CARDIMAGEPANEL = "Image card";
    static final String CARDEMPTYPANEL = "Empty card";
    private JPEGTablesTag jtt;
    private HashMap<Integer, CharacterTag> characters;
    private File tempFile;

    private void parseCharacters(List<Object> list) {
        for (Object t : list) {
            if (t instanceof CharacterTag) {
                this.characters.put(((CharacterTag)t).getCharacterID(), (CharacterTag)t);
            }
            if (!(t instanceof Container)) continue;
            this.parseCharacters(((Container)t).getSubItems());
        }
    }

    public TagPanel(List<Tag> list, SWF swf) {
        this.swf = swf;
        for (Tag t : swf.tags) {
            if (!(t instanceof JPEGTablesTag)) continue;
            this.jtt = (JPEGTablesTag)t;
        }
        this.characters = new HashMap();
        ArrayList<Object> list2 = new ArrayList<Object>();
        list2.addAll(swf.tags);
        this.parseCharacters(list2);
        this.tagList = new JList<Tag>(list.toArray(new Tag[list.size()]));
        this.tagList.addListSelectionListener(this);
        this.setLayout(new BorderLayout());
        try {
            this.flashPanel = new FlashPanel();
        }
        catch (Error e) {
            e.printStackTrace();
        }
        this.displayPanel = new JPanel(new CardLayout());
        if (this.flashPanel != null) {
            this.displayPanel.add((Component)this.flashPanel, CARDFLASHPANEL);
        } else {
            JPanel swtPanel = new JPanel(new BorderLayout());
            swtPanel.add((Component)new JLabel("<html><center>Preview of this object is not available on this platform. (Windows only)</center></html>", 0), "Center");
            swtPanel.setBackground(Color.white);
            this.displayPanel.add((Component)swtPanel, CARDFLASHPANEL);
        }
        this.imagePanel = new ImagePanel();
        this.displayPanel.add((Component)this.imagePanel, CARDIMAGEPANEL);
        this.displayPanel.add((Component)new JPanel(), CARDEMPTYPANEL);
        CardLayout cl = (CardLayout)this.displayPanel.getLayout();
        cl.show(this.displayPanel, CARDEMPTYPANEL);
        this.tagList.setBorder(BorderFactory.createLoweredBevelBorder());
        this.displayPanel.setBorder(BorderFactory.createLineBorder(Color.black));
        this.add((Component)new JScrollPane(this.tagList), "West");
        this.add((Component)this.displayPanel, "Center");
    }

    public void showCard(String card) {
        CardLayout cl = (CardLayout)this.displayPanel.getLayout();
        cl.show(this.displayPanel, card);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Tag tagObj = (Tag)this.tagList.getSelectedValue();
        if (tagObj instanceof DefineBitsTag) {
            this.showCard(CARDIMAGEPANEL);
            this.imagePanel.setImage(((DefineBitsTag)tagObj).getFullImageData(this.jtt));
        } else if (tagObj instanceof DefineBitsJPEG2Tag) {
            this.showCard(CARDIMAGEPANEL);
            this.imagePanel.setImage(((DefineBitsJPEG2Tag)tagObj).imageData);
        } else if (tagObj instanceof DefineBitsJPEG3Tag) {
            this.showCard(CARDIMAGEPANEL);
            this.imagePanel.setImage(((DefineBitsJPEG3Tag)tagObj).imageData);
        } else if (tagObj instanceof DefineBitsJPEG4Tag) {
            this.showCard(CARDIMAGEPANEL);
            this.imagePanel.setImage(((DefineBitsJPEG4Tag)tagObj).imageData);
        } else if (tagObj instanceof DefineBitsLosslessTag) {
            this.showCard(CARDIMAGEPANEL);
            this.imagePanel.setImage(((DefineBitsLosslessTag)tagObj).getImage());
        } else if (tagObj instanceof DefineBitsLossless2Tag) {
            this.showCard(CARDIMAGEPANEL);
            this.imagePanel.setImage(((DefineBitsLossless2Tag)tagObj).getImage());
        } else if ((tagObj instanceof CharacterTag || tagObj instanceof FontTag) && tagObj instanceof Tag) {
            try {
                if (this.tempFile != null) {
                    this.tempFile.delete();
                }
                this.tempFile = File.createTempFile("temp", ".swf");
                this.tempFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(this.tempFile);
                SWFOutputStream sos = new SWFOutputStream(fos, 10);
                sos.write("FWS".getBytes());
                sos.write(13);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                SWFOutputStream sos2 = new SWFOutputStream(baos, 10);
                int width = this.swf.displayRect.Xmax - this.swf.displayRect.Xmin;
                int height = this.swf.displayRect.Ymax - this.swf.displayRect.Ymin;
                sos2.writeRECT(this.swf.displayRect);
                sos2.writeUI8(0);
                sos2.writeUI8(this.swf.frameRate);
                sos2.writeUI16(100);
                sos2.writeTag(new SetBackgroundColorTag(new RGB(255, 255, 255)));
                if (tagObj instanceof DefineBitsTag) {
                    if (this.jtt != null) {
                        sos2.writeTag(this.jtt);
                    }
                } else if (!(tagObj instanceof AloneTag)) {
                    Set<Integer> needed = tagObj.getNeededCharacters();
                    for (int n : needed) {
                        sos2.writeTag(this.characters.get(n));
                    }
                }
                sos2.writeTag(tagObj);
                int chtId = 0;
                if (tagObj instanceof CharacterTag) {
                    chtId = ((CharacterTag)tagObj).getCharacterID();
                }
                MATRIX mat = new MATRIX();
                mat.hasRotate = false;
                mat.hasScale = false;
                mat.translateX = 0;
                mat.translateY = 0;
                if (tagObj instanceof BoundedTag) {
                    RECT r = ((BoundedTag)((Object)tagObj)).getRect();
                    mat.translateX = -r.Xmin;
                    mat.translateY = -r.Ymin;
                    mat.translateX = mat.translateX + width / 2 - r.getWidth() / 2;
                    mat.translateY = mat.translateY + height / 2 - r.getHeight() / 2;
                } else {
                    mat.translateX = width / 4;
                    mat.translateY = height / 4;
                }
                if (tagObj instanceof FontTag) {
                    int countGlyphs = ((FontTag)((Object)tagObj)).getGlyphShapeTable().length;
                    int fontId = ((FontTag)((Object)tagObj)).getFontId();
                    int sloupcu = (int)Math.ceil(Math.sqrt(countGlyphs));
                    int radku = (int)Math.ceil((float)countGlyphs / (float)sloupcu);
                    int x = 0;
                    int y = 1;
                    for (int f = 0; f < countGlyphs; ++f) {
                        if (x >= sloupcu) {
                            x = 0;
                            ++y;
                        }
                        ArrayList<TEXTRECORD> rec = new ArrayList<TEXTRECORD>();
                        TEXTRECORD tr = new TEXTRECORD();
                        int textHeight = height / radku;
                        tr.fontId = fontId;
                        tr.styleFlagsHasFont = true;
                        tr.textHeight = textHeight;
                        tr.glyphEntries = new GLYPHENTRY[1];
                        tr.styleFlagsHasColor = true;
                        tr.textColor = new RGB(0, 0, 0);
                        tr.glyphEntries[0] = new GLYPHENTRY();
                        tr.glyphEntries[0].glyphAdvance = 0;
                        tr.glyphEntries[0].glyphIndex = f;
                        rec.add(tr);
                        mat.translateX = x * width / sloupcu;
                        mat.translateY = y * height / radku;
                        sos2.writeTag(new DefineTextTag(999 + f, new RECT(0, width, 0, height), new MATRIX(), SWFOutputStream.getNeededBitsU(countGlyphs - 1), SWFOutputStream.getNeededBitsU(0), rec));
                        sos2.writeTag(new PlaceObject2Tag(false, false, false, true, false, true, true, false, 1 + f, 999 + f, mat, null, 0, null, 0, null));
                        ++x;
                    }
                    sos2.writeTag(new ShowFrameTag());
                } else if (tagObj instanceof DefineMorphShapeTag || tagObj instanceof DefineMorphShape2Tag) {
                    sos2.writeTag(new PlaceObject2Tag(false, false, false, true, false, true, true, false, 1, chtId, mat, null, 0, null, 0, null));
                    sos2.writeTag(new ShowFrameTag());
                    int numFrames = 100;
                    for (int ratio = 0; ratio < 65536; ratio += 65536 / numFrames) {
                        sos2.writeTag(new PlaceObject2Tag(false, false, false, true, false, true, false, true, 1, chtId, mat, null, ratio, null, 0, null));
                        sos2.writeTag(new ShowFrameTag());
                    }
                } else {
                    sos2.writeTag(new PlaceObject2Tag(false, false, false, true, false, true, true, false, 1, chtId, mat, null, 0, null, 0, null));
                    sos2.writeTag(new ShowFrameTag());
                }
                sos2.writeTag(new EndTag());
                byte[] data = baos.toByteArray();
                sos.writeUI32(sos.getPos() + (long)data.length + 4L);
                sos.write(data);
                fos.close();
                this.showCard(CARDFLASHPANEL);
                if (this.flashPanel != null && this.flashPanel instanceof FlashPanel) {
                    this.flashPanel.displaySWF(this.tempFile.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                Logger.getLogger(TagPanel.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    static {
        try {
            File.createTempFile("temp", ".swf").delete();
        }
        catch (IOException ex) {
            Logger.getLogger(TagPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}

