/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel.clauses;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.ContinueTreeItem;
import com.jpexs.asdec.action.treemodel.TreeItem;
import com.jpexs.asdec.action.treemodel.clauses.Block;
import com.jpexs.asdec.action.treemodel.clauses.LoopTreeItem;
import java.util.ArrayList;
import java.util.List;

public class SwitchTreeItem
extends LoopTreeItem
implements Block {
    public TreeItem switchedObject;
    public List<TreeItem> caseValues;
    public List<List<TreeItem>> caseCommands;
    public List<TreeItem> defaultCommands;

    public SwitchTreeItem(Action instruction, long switchBreak, TreeItem switchedObject, List<TreeItem> caseValues, List<List<TreeItem>> caseCommands, List<TreeItem> defaultCommands) {
        super(instruction, switchBreak, -1L);
        this.switchedObject = switchedObject;
        this.caseValues = caseValues;
        this.caseCommands = caseCommands;
        this.defaultCommands = defaultCommands;
    }

    @Override
    public String toString(ConstantPool constants) {
        String ret = "";
        ret = ret + "loopswitch" + this.loopBreak + ":\r\n";
        ret = ret + this.hilight("switch(") + this.switchedObject.toString(constants) + this.hilight(")") + "\r\n{\r\n";
        for (int i = 0; i < this.caseValues.size(); ++i) {
            ret = ret + "case " + this.caseValues.get(i).toString(constants) + ":\r\n";
            ret = ret + "INDENTOPEN\r\n";
            for (int j = 0; j < this.caseCommands.get(i).size(); ++j) {
                ret = ret + this.caseCommands.get(i).get(j).toString(constants) + "\r\n";
            }
            ret = ret + "INDENTCLOSE\r\n";
        }
        if (this.defaultCommands != null && this.defaultCommands.size() > 0) {
            ret = ret + this.hilight("default") + ":\r\n";
            ret = ret + "INDENTOPEN\r\n";
            for (int j = 0; j < this.defaultCommands.size(); ++j) {
                ret = ret + this.defaultCommands.get(j).toString(constants) + "\r\n";
            }
            ret = ret + "INDENTCLOSE\r\n";
        }
        ret = ret + this.hilight("}") + "\r\n";
        ret = ret + ":loop" + this.loopBreak;
        return ret;
    }

    @Override
    public List<ContinueTreeItem> getContinues() {
        ArrayList<ContinueTreeItem> ret = new ArrayList<ContinueTreeItem>();
        for (List<TreeItem> onecase : this.caseCommands) {
            for (TreeItem ti : onecase) {
                if (ti instanceof ContinueTreeItem) {
                    ret.add((ContinueTreeItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        if (this.defaultCommands != null) {
            for (TreeItem ti : this.defaultCommands) {
                if (ti instanceof ContinueTreeItem) {
                    ret.add((ContinueTreeItem)ti);
                }
                if (!(ti instanceof Block)) continue;
                ret.addAll(((Block)((Object)ti)).getContinues());
            }
        }
        return ret;
    }
}

