/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel.clauses;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.ContinueTreeItem;
import com.jpexs.asdec.action.treemodel.TreeItem;
import com.jpexs.asdec.action.treemodel.clauses.Block;
import java.util.ArrayList;
import java.util.List;

public class IfTreeItem
extends TreeItem
implements Block {
    public TreeItem expression;
    public List<TreeItem> onTrue;
    public List<TreeItem> onFalse;

    public IfTreeItem(Action instruction, TreeItem expression, List<TreeItem> onTrue, List<TreeItem> onFalse) {
        super(instruction, 16);
        this.expression = expression;
        this.onTrue = onTrue;
        this.onFalse = onFalse;
    }

    @Override
    public String toString(ConstantPool constants) {
        String ret = this.hilight("if(") + this.expression.toString(constants) + this.hilight(")") + "\r\n{\r\n";
        for (TreeItem ti : this.onTrue) {
            ret = ret + ti.toString(constants) + "\r\n";
        }
        ret = ret + this.hilight("}");
        if (this.onFalse.size() > 0) {
            ret = ret + this.hilight("\r\nelse\r\n{\r\n");
            for (TreeItem ti : this.onFalse) {
                ret = ret + ti.toString(constants) + "\r\n";
            }
            ret = ret + this.hilight("}");
        }
        return ret;
    }

    @Override
    public List<ContinueTreeItem> getContinues() {
        ArrayList<ContinueTreeItem> ret = new ArrayList<ContinueTreeItem>();
        for (TreeItem ti : this.onTrue) {
            if (ti instanceof ContinueTreeItem) {
                ret.add((ContinueTreeItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        for (TreeItem ti : this.onFalse) {
            if (ti instanceof ContinueTreeItem) {
                ret.add((ContinueTreeItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }
}

