/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.TreeItem;
import java.util.List;

public class FunctionTreeItem
extends TreeItem {
    public List<TreeItem> actions;
    public List<String> constants;
    public String functionName;
    public List<String> paramNames;

    public FunctionTreeItem(Action instruction, String functionName, List<String> paramNames, List<TreeItem> actions, ConstantPool constants) {
        super(instruction, 0);
        this.actions = actions;
        this.constants = constants.constants;
        this.functionName = functionName;
        this.paramNames = paramNames;
    }

    @Override
    public String toString(ConstantPool constants) {
        String ret = "function";
        if (!this.functionName.equals("")) {
            ret = ret + " " + this.functionName;
        }
        ret = ret + "(";
        for (int p = 0; p < this.paramNames.size(); ++p) {
            if (p > 0) {
                ret = ret + ", ";
            }
            ret = ret + this.paramNames.get(p);
        }
        ret = ret + ")\r\n{\r\n" + Action.treeToString(this.actions) + "}";
        return ret;
    }
}

