/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.treemodel;

import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.swf4.ConstantIndex;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.TreeItem;
import com.jpexs.asdec.helpers.Helper;
import java.util.List;

public class DirectValueTreeItem
extends TreeItem {
    public Object value;
    public List<String> constants;

    public DirectValueTreeItem(Action instruction, Object value, ConstantPool constants) {
        super(instruction, 0);
        this.constants = constants.constants;
        this.value = value;
    }

    public String toStringNoQuotes(ConstantPool constants) {
        if (this.value instanceof Double && Double.compare((Double)this.value, 0.0) == 0) {
            return "0";
        }
        if (this.value instanceof Float && Float.compare(((Float)this.value).floatValue(), 0.0f) == 0) {
            return "0";
        }
        if (this.value instanceof String) {
            return Helper.escapeString((String)this.value);
        }
        if (this.value instanceof ConstantIndex) {
            return this.constants.get(((ConstantIndex)this.value).index);
        }
        return this.value.toString();
    }

    @Override
    public String toString(ConstantPool constants) {
        if (this.value instanceof Double && Double.compare((Double)this.value, 0.0) == 0) {
            return "0";
        }
        if (this.value instanceof Float && Float.compare(((Float)this.value).floatValue(), 0.0f) == 0) {
            return "0";
        }
        if (this.value instanceof String) {
            return "\"" + Helper.escapeString((String)this.value) + "\"";
        }
        if (this.value instanceof ConstantIndex) {
            return "\"" + Helper.escapeString(this.constants.get(((ConstantIndex)this.value).index)) + "\"";
        }
        return this.value.toString();
    }
}

