/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.action.swf4;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.action.Action;
import com.jpexs.asdec.action.parser.FlasmLexer;
import com.jpexs.asdec.action.parser.ParseException;
import com.jpexs.asdec.action.parser.ParsedSymbol;
import com.jpexs.asdec.action.swf4.ConstantIndex;
import com.jpexs.asdec.action.swf4.Null;
import com.jpexs.asdec.action.swf4.RegisterNumber;
import com.jpexs.asdec.action.swf4.Undefined;
import com.jpexs.asdec.action.treemodel.ConstantPool;
import com.jpexs.asdec.action.treemodel.DirectValueTreeItem;
import com.jpexs.asdec.action.treemodel.TreeItem;
import com.jpexs.asdec.helpers.Helper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;

public class ActionPush
extends Action {
    public List<Object> values;
    public List<String> constantPool;

    public ActionPush(int actionLength, SWFInputStream sis, int version) throws IOException {
        super(150, actionLength);
        int type;
        this.values = new ArrayList<Object>();
        sis = new SWFInputStream(new ByteArrayInputStream(sis.readBytes(actionLength)), version);
        while ((type = sis.readUI8()) > -1) {
            switch (type) {
                case 0: {
                    this.values.add(sis.readString());
                    break;
                }
                case 1: {
                    this.values.add(Float.valueOf(sis.readFLOAT()));
                    break;
                }
                case 2: {
                    this.values.add(new Null());
                    break;
                }
                case 3: {
                    this.values.add(new Undefined());
                    break;
                }
                case 4: {
                    this.values.add(new RegisterNumber(sis.readUI8()));
                    break;
                }
                case 5: {
                    this.values.add(sis.readUI8() == 1);
                    break;
                }
                case 6: {
                    this.values.add(sis.readDOUBLE());
                    break;
                }
                case 7: {
                    this.values.add(sis.readUI32());
                    break;
                }
                case 8: {
                    this.values.add(new ConstantIndex(sis.readUI8()));
                    break;
                }
                case 9: {
                    this.values.add(new ConstantIndex(sis.readUI16()));
                }
            }
        }
    }

    @Override
    public byte[] getBytes(int version) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SWFOutputStream sos = new SWFOutputStream(baos, version);
        try {
            for (Object o : this.values) {
                if (o instanceof String) {
                    sos.writeUI8(0);
                    sos.writeString((String)o);
                }
                if (o instanceof Float) {
                    sos.writeUI8(1);
                    sos.writeFLOAT(((Float)o).floatValue());
                }
                if (o instanceof Null) {
                    sos.writeUI8(2);
                }
                if (o instanceof Undefined) {
                    sos.writeUI8(3);
                }
                if (o instanceof RegisterNumber) {
                    sos.writeUI8(4);
                    sos.writeUI8(((RegisterNumber)o).number);
                }
                if (o instanceof Boolean) {
                    sos.writeUI8(5);
                    sos.writeUI8((Boolean)o != false ? 1 : 0);
                }
                if (o instanceof Double) {
                    sos.writeUI8(6);
                    sos.writeDOUBLE((Double)o);
                }
                if (o instanceof Long) {
                    sos.writeUI8(7);
                    sos.writeUI32((Long)o);
                }
                if (!(o instanceof ConstantIndex)) continue;
                int cIndex = ((ConstantIndex)o).index;
                if (cIndex < 256) {
                    sos.writeUI8(8);
                    sos.writeUI8(cIndex);
                    continue;
                }
                sos.writeUI8(9);
                sos.writeUI16(cIndex);
            }
            sos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.surroundWithAction(baos.toByteArray(), version);
    }

    public ActionPush(FlasmLexer lexer, List<String> constantPool) throws IOException, ParseException {
        super(150, 0);
        this.constantPool = constantPool;
        this.values = new ArrayList<Object>();
        int count = 0;
        block5: while (true) {
            ParsedSymbol symb = lexer.yylex();
            switch (symb.type) {
                case 1: {
                    ++count;
                    if (constantPool.contains((String)symb.value)) {
                        this.values.add(new ConstantIndex(constantPool.indexOf(symb.value), constantPool));
                        break;
                    }
                    this.values.add(symb.value);
                    break;
                }
                case 4: 
                case 5: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    ++count;
                    this.values.add(symb.value);
                    break;
                }
                case 7: 
                case 16: {
                    if (count != 0) break block5;
                    throw new ParseException("Arguments expected", lexer.yyline());
                }
                default: {
                    throw new ParseException("Arguments expected", lexer.yyline());
                }
            }
        }
    }

    @Override
    public String toString() {
        String ret = "Push ";
        for (int i = 0; i < this.values.size(); ++i) {
            if (i > 0) {
                ret = ret + " ";
            }
            if (this.values.get(i) instanceof ConstantIndex) {
                ((ConstantIndex)this.values.get((int)i)).constantPool = this.constantPool;
                ret = ret + ((ConstantIndex)this.values.get(i)).toString();
                continue;
            }
            if (this.values.get(i) instanceof String) {
                ret = ret + "\"" + Helper.escapeString((String)this.values.get(i)) + "\"";
                continue;
            }
            if (this.values.get(i) instanceof Long) {
                long l = (Long)this.values.get(i);
                ret = ret + (l &= 0xFFFFFFFFL);
                continue;
            }
            ret = ret + this.values.get(i).toString();
        }
        return ret;
    }

    @Override
    public void translate(Stack<TreeItem> stack, ConstantPool constants, List<TreeItem> output, HashMap<Integer, String> regNames) {
        for (Object o : this.values) {
            if (o instanceof ConstantIndex) {
                o = constants.constants.get(((ConstantIndex)o).index);
            }
            if (o instanceof RegisterNumber && regNames.containsKey(((RegisterNumber)o).number)) {
                ((RegisterNumber)o).name = regNames.get(((RegisterNumber)o).number);
            }
            stack.push(new DirectValueTreeItem(this, o, constants));
        }
    }
}

