/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types.traits;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.helpers.Helper;
import com.jpexs.asdec.tags.DoABCTag;
import java.util.List;

public abstract class Trait {
    public int name_index;
    public int kindType;
    public int kindFlags;
    public int[] metadata = new int[0];
    public long fileOffset;
    public byte[] bytes;
    public static final int ATTR_Final = 1;
    public static final int ATTR_Override = 2;
    public static final int ATTR_Metadata = 4;
    public static final int TRAIT_SLOT = 0;
    public static final int TRAIT_METHOD = 1;
    public static final int TRAIT_GETTER = 2;
    public static final int TRAIT_SETTER = 3;
    public static final int TRAIT_CLASS = 4;
    public static final int TRAIT_FUNCTION = 5;
    public static final int TRAIT_CONST = 6;

    public String getModifiers(List<DoABCTag> abcTags, ABC abc, boolean isStatic) {
        Multiname m;
        String ret = "";
        if ((this.kindFlags & 2) > 0) {
            ret = ret + "override";
        }
        if ((m = this.getName(abc)) != null) {
            String nsname = "";
            for (DoABCTag abcTag : abcTags) {
                nsname = abcTag.abc.nsValueToName(abc.constants.constant_namespace[m.namespace_index].getName(abc.constants));
                if (nsname.equals("-")) break;
                if (nsname.contains(".")) {
                    nsname = nsname.substring(nsname.lastIndexOf(".") + 1);
                }
                if (nsname.equals("")) continue;
                break;
            }
            Namespace ns = m.getNamespace(abc.constants);
            if (nsname.contains(":")) {
                nsname = "";
            }
            if ((nsname.equals("") || nsname.equals("-")) && ns != null && ns.kind == 8) {
                nsname = ns.getName(abc.constants);
            }
            if (!nsname.contains(":")) {
                ret = ret + " " + nsname;
            }
            if (ns != null) {
                ret = ret + " " + ns.getPrefix(abc);
            }
        }
        if (isStatic) {
            ret = ret + " static";
        }
        if ((this.kindFlags & 1) > 0 && !isStatic) {
            ret = ret + " final";
        }
        return ret.trim();
    }

    public String toString() {
        return "name_index=" + this.name_index + " kind=" + this.kindType + " metadata=" + Helper.intArrToString(this.metadata);
    }

    public String toString(ABC abc, List<String> fullyQualifiedNames) {
        return abc.constants.constant_multiname[this.name_index].toString(abc.constants, fullyQualifiedNames) + " kind=" + this.kindType + " metadata=" + Helper.intArrToString(this.metadata);
    }

    public String convert(List<DoABCTag> abcTags, ABC abc, boolean isStatic, boolean pcode, int classIndex, boolean highlight, List<String> fullyQualifiedNames) {
        return abc.constants.constant_multiname[this.name_index].toString(abc.constants, fullyQualifiedNames) + " kind=" + this.kindType + " metadata=" + Helper.intArrToString(this.metadata);
    }

    public String convertPackaged(List<DoABCTag> abcTags, ABC abc, boolean isStatic, boolean pcod, int classIndex, boolean highlight, List<String> fullyQualifiedNames) {
        return this.makePackageFromIndex(abc, this.name_index, this.convert(abcTags, abc, isStatic, pcod, classIndex, highlight, fullyQualifiedNames));
    }

    public String convertHeader(List<DoABCTag> abcTags, ABC abc, boolean isStatic, boolean pcode, int classIndex, boolean highlight, List<String> fullyQualifiedNames) {
        return this.convert(abcTags, abc, isStatic, pcode, classIndex, highlight, fullyQualifiedNames).trim();
    }

    protected String makePackageFromIndex(ABC abc, int name_index, String value) {
        Namespace ns = abc.constants.constant_multiname[name_index].getNamespace(abc.constants);
        if (ns.kind == 22 || ns.kind == 23) {
            String nsname = ns.getName(abc.constants);
            return "package " + nsname + "\r\n{\r\n" + value + "\r\n}";
        }
        return value;
    }

    public Multiname getName(ABC abc) {
        if (this.name_index == 0) {
            return null;
        }
        return abc.constants.constant_multiname[this.name_index];
    }
}

