/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.helpers.Helper;

public class ValueKind {
    public static final int CONSTANT_Decimal = 2;
    public static final int CONSTANT_Int = 3;
    public static final int CONSTANT_UInt = 4;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_True = 11;
    public static final int CONSTANT_False = 10;
    public static final int CONSTANT_Null = 12;
    public static final int CONSTANT_Undefined = 0;
    public static final int CONSTANT_Namespace = 8;
    public static final int CONSTANT_PackageNamespace = 22;
    public static final int CONSTANT_PackageInternalNs = 23;
    public static final int CONSTANT_ProtectedNamespace = 24;
    public static final int CONSTANT_ExplicitNamespace = 25;
    public static final int CONSTANT_StaticProtectedNs = 26;
    public static final int CONSTANT_PrivateNs = 5;
    private static final int[] optionalKinds = new int[]{3, 4, 6, 2, 1, 11, 10, 12, 0, 8, 22, 23, 24, 25, 26, 5};
    private static final String[] optionalKindNames = new String[]{"Int", "UInt", "Double", "Decimal", "Utf8", "True", "False", "Null", "Undefined", "Namespace", "PackageNamespace", "PackageInternalNs", "ProtectedNamespace", "ExplicitNamespace", "StaticProtectedNs", "PrivateNs"};
    public int value_index;
    public int value_kind;

    public ValueKind(int value_index, int value_kind) {
        this.value_index = value_index;
        this.value_kind = value_kind;
    }

    public String toString() {
        String s = "";
        s = s + this.value_index + ":";
        boolean found = false;
        for (int i = 0; i < optionalKinds.length; ++i) {
            if (optionalKinds[i] != this.value_kind) continue;
            s = s + optionalKindNames[i];
            found = true;
            break;
        }
        if (!found) {
            s = s + "?";
        }
        return s;
    }

    public boolean isNamespace() {
        switch (this.value_kind) {
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public String toString(ConstantPool constants) {
        String ret = "?";
        switch (this.value_kind) {
            case 3: {
                ret = "" + constants.constant_int[this.value_index];
                break;
            }
            case 4: {
                ret = "" + constants.constant_uint[this.value_index];
                break;
            }
            case 6: {
                ret = "" + constants.constant_double[this.value_index];
                break;
            }
            case 2: {
                ret = "" + constants.constant_decimal[this.value_index];
                break;
            }
            case 1: {
                ret = "\"" + Helper.escapeString(constants.constant_string[this.value_index]) + "\"";
                break;
            }
            case 11: {
                ret = "true";
                break;
            }
            case 10: {
                ret = "false";
                break;
            }
            case 12: {
                ret = "null";
                break;
            }
            case 0: {
                ret = "undefined";
                break;
            }
            case 5: 
            case 8: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                ret = "\"" + constants.constant_namespace[this.value_index].getName(constants) + "\"";
            }
        }
        return ret;
    }
}

