/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.types.Multiname;
import com.jpexs.asdec.abc.types.Namespace;
import com.jpexs.asdec.abc.types.traits.Trait;
import com.jpexs.asdec.abc.types.traits.Traits;
import com.jpexs.asdec.tags.DoABCTag;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ScriptInfo {
    public int init_index;
    public Traits traits;

    public String toString() {
        return "method_index=" + this.init_index + "\r\n" + this.traits.toString();
    }

    public String toString(ABC abc, List<String> fullyQualifiedNames) {
        return "method_index=" + this.init_index + "\r\n" + this.traits.toString(abc, fullyQualifiedNames);
    }

    public String getPath(ABC abc) {
        for (Trait t : this.traits.traits) {
            Multiname name = t.getName(abc);
            Namespace ns = name.getNamespace(abc.constants);
            if (ns.kind != 22 && ns.kind != 23) continue;
            return ns.getName(abc.constants) + "." + name.getName(abc.constants, new ArrayList<String>());
        }
        return "";
    }

    public String convert(List<DoABCTag> abcTags, ABC abc, boolean pcode, boolean highlighting) {
        return this.traits.convert(abcTags, abc, false, pcode, true, -1, highlighting, new ArrayList<String>());
    }

    public void export(ABC abc, List<DoABCTag> abcList, String directory, boolean pcode) throws IOException {
        String path = this.getPath(abc);
        String packageName = path.substring(0, path.lastIndexOf("."));
        String className = path.substring(path.lastIndexOf(".") + 1);
        File outDir = new File(directory + File.separatorChar + packageName.replace('.', File.separatorChar));
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        String fileName = outDir.toString() + File.separator + className + ".as";
        FileOutputStream fos = new FileOutputStream(fileName);
        fos.write(this.convert(abcList, abc, pcode, false).getBytes());
        fos.close();
    }
}

