/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.types;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.ConstantPool;

public class Namespace {
    public static final int KIND_NAMESPACE = 8;
    public static final int KIND_PRIVATE = 5;
    public static final int KIND_PACKAGE = 22;
    public static final int KIND_PACKAGE_INTERNAL = 23;
    public static final int KIND_PROTECTED = 24;
    public static final int KIND_EXPLICIT = 25;
    public static final int KIND_STATIC_PROTECTED = 26;
    public static final int[] nameSpaceKinds = new int[]{8, 5, 22, 23, 24, 25, 26};
    public static final String[] nameSpaceKindNames = new String[]{"Namespace", "PrivateNamespace", "PackageNamespace", "PackageInternalNamespace", "ProtectedNamespace", "ExplicitNamespace", "StaticProtectedNamespace"};
    public static final String[] namePrefixes = new String[]{"", "private", "public", "", "protected", "explicit", "protected"};
    public int kind;
    public int name_index;

    public Namespace(int kind, int name_index) {
        this.kind = kind;
        this.name_index = name_index;
    }

    public String getKindStr() {
        String kindStr = "?";
        for (int k = 0; k < nameSpaceKinds.length; ++k) {
            if (nameSpaceKinds[k] != this.kind) continue;
            kindStr = nameSpaceKindNames[k];
            break;
        }
        return kindStr;
    }

    public String toString() {
        return "Namespace: kind=" + this.getKindStr() + " name_index=" + this.name_index;
    }

    public String toString(ConstantPool constants) {
        return this.getName(constants);
    }

    public String getNameWithKind(ConstantPool constants) {
        String kindStr = this.getKindStr();
        String nameStr = constants.constant_string[this.name_index];
        return kindStr + (nameStr.equals("") ? "" : " " + nameStr);
    }

    public String getPrefix(ABC abc) {
        String kindStr = "?";
        for (int k = 0; k < nameSpaceKinds.length; ++k) {
            if (nameSpaceKinds[k] != this.kind) continue;
            kindStr = namePrefixes[k];
            break;
        }
        return kindStr;
    }

    public String getName(ConstantPool constants) {
        if (this.name_index == 0) {
            return "-";
        }
        return constants.constant_string[this.name_index];
    }
}

