/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.abc.gui.TreeVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.tree.TreePath;

public class TreeElement {
    private SortedMap<String, TreeElement> branches;
    private SortedMap<String, TreeElement> leafs;
    private String name;
    private String path;
    private Object item;
    private TreeElement parent;

    public TreeElement(String name, String path, Object item, TreeElement parent) {
        this.name = name;
        this.path = path;
        this.item = item;
        this.parent = parent;
        this.branches = new TreeMap<String, TreeElement>();
        this.leafs = new TreeMap<String, TreeElement>();
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public TreePath getTreePath() {
        ArrayList<TreeElement> pathList = new ArrayList<TreeElement>();
        TreeElement temp = this;
        do {
            pathList.add(0, temp);
        } while ((temp = temp.getParent()) != null);
        return new TreePath(pathList.toArray());
    }

    public Object getItem() {
        return this.item;
    }

    public String toString() {
        return this.name;
    }

    TreeElement getBranch(String pathElement) {
        TreeElement branch = (TreeElement)this.branches.get(pathElement);
        if (branch == null) {
            branch = new TreeElement(pathElement, this.path + "." + pathElement, null, this);
            this.branches.put(pathElement, branch);
        }
        return branch;
    }

    void addLeaf(String pathElement, Object item) {
        TreeElement child = new TreeElement(pathElement, this.path + "." + pathElement, item, this);
        this.leafs.put(pathElement, child);
    }

    public TreeElement getChild(int index) {
        int startingIndex;
        Iterator<TreeElement> iter;
        if (index < this.branches.size()) {
            iter = this.branches.values().iterator();
            startingIndex = 0;
        } else {
            iter = this.leafs.values().iterator();
            startingIndex = this.branches.size();
        }
        TreeElement child = null;
        for (int ii = startingIndex; ii <= index && iter.hasNext(); ++ii) {
            child = iter.next();
        }
        return child;
    }

    public int getChildCount() {
        return this.branches.size() + this.leafs.size();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public int getIndexOfChild(TreeElement child) {
        if (this.getChildCount() < 1) {
            return -1;
        }
        Iterator<TreeElement> iter = this.branches.values().iterator();
        int ii = 0;
        TreeElement aChild = null;
        while (aChild != child && iter.hasNext()) {
            aChild = iter.next();
            if (aChild == child) {
                return ii;
            }
            ++ii;
        }
        iter = this.leafs.values().iterator();
        while (aChild != child && iter.hasNext()) {
            aChild = iter.next();
            if (aChild == child) {
                return ii;
            }
            ++ii;
        }
        return -1;
    }

    void visitBranches(TreeVisitor visitor) {
        for (TreeElement branch : this.branches.values()) {
            visitor.onBranch(branch);
            branch.visitLeafs(visitor);
            branch.visitBranches(visitor);
        }
    }

    void visitLeafs(TreeVisitor visitor) {
        for (TreeElement leaf : this.leafs.values()) {
            visitor.onLeaf(leaf);
        }
    }

    TreeElement getByPath(String fullPath) {
        TreeElement te = this;
        StringTokenizer st = new StringTokenizer(fullPath, ".");
        while (st.hasMoreTokens()) {
            String pathElement = st.nextToken();
            TreeElement nte = (TreeElement)te.branches.get(pathElement);
            if (nte == null) {
                nte = (TreeElement)te.leafs.get(pathElement);
            }
            te = nte;
        }
        return te;
    }
}

