/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.gui.TraitDetail;
import com.jpexs.asdec.abc.methodinfo_parser.MethodInfoParser;
import com.jpexs.asdec.abc.methodinfo_parser.ParseException;
import com.jpexs.asdec.abc.types.ValueKind;
import com.jpexs.asdec.abc.types.traits.TraitSlotConst;
import com.jpexs.asdec.helpers.Helper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jsyntaxpane.syntaxkits.Flasm3MethodInfoSyntaxKit;

public class SlotConstTraitDetailPanel
extends JPanel
implements TraitDetail {
    public JEditorPane slotConstEditor = new JEditorPane();
    private ABC abc;
    private TraitSlotConst trait;

    public SlotConstTraitDetailPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel("Type and Value:"), "North");
        this.add((Component)new JScrollPane(this.slotConstEditor), "Center");
        this.slotConstEditor.setContentType("text/flasm3_methodinfo");
        Flasm3MethodInfoSyntaxKit sk = (Flasm3MethodInfoSyntaxKit)this.slotConstEditor.getEditorKit();
        sk.deinstallComponent(this.slotConstEditor, "jsyntaxpane.components.LineNumbersRuler");
    }

    public void load(TraitSlotConst trait, ABC abc) {
        this.abc = abc;
        this.trait = trait;
        String typeStr = trait.type_index > 0 ? "m[" + trait.type_index + "]\"" + Helper.escapeString(abc.constants.constant_multiname[trait.type_index].toString(abc.constants, new ArrayList<String>())) + "\"" : "*";
        String valueStr = "";
        if (trait.value_kind != 0) {
            valueStr = " = " + new ValueKind(trait.value_index, trait.value_kind).toString(abc.constants);
        }
        String s = typeStr + valueStr;
        this.slotConstEditor.setText(s);
    }

    @Override
    public boolean save() {
        try {
            if (!MethodInfoParser.parseSlotConst(this.slotConstEditor.getText(), this.trait, this.abc)) {
                return false;
            }
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this.slotConstEditor, ex.text, "SlotConst typevalue Error", 0);
            return false;
        }
        return true;
    }
}

