/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.helpers.Helper;
import java.util.ArrayList;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class ConstantsListModel
implements ListModel {
    private ConstantPool constants;
    public static final int TYPE_UINT = 0;
    public static final int TYPE_INT = 1;
    public static final int TYPE_DOUBLE = 2;
    public static final int TYPE_DECIMAL = 3;
    public static final int TYPE_STRING = 4;
    public static final int TYPE_NAMESPACE = 5;
    public static final int TYPE_NAMESPACESET = 6;
    public static final int TYPE_MULTINAME = 7;
    private int type = 1;

    public ConstantsListModel(ConstantPool constants, int type) {
        this.type = type;
        this.constants = constants;
    }

    private int makeUp(int i) {
        if (i < 0) {
            return 0;
        }
        return i;
    }

    @Override
    public int getSize() {
        switch (this.type) {
            case 0: {
                return this.makeUp(this.constants.constant_uint.length - 1);
            }
            case 1: {
                return this.makeUp(this.constants.constant_int.length - 1);
            }
            case 2: {
                return this.makeUp(this.constants.constant_double.length - 1);
            }
            case 3: {
                return this.makeUp(this.constants.constant_decimal.length - 1);
            }
            case 4: {
                return this.makeUp(this.constants.constant_string.length - 1);
            }
            case 5: {
                return this.makeUp(this.constants.constant_namespace.length - 1);
            }
            case 6: {
                return this.makeUp(this.constants.constant_namespace_set.length - 1);
            }
            case 7: {
                return this.makeUp(this.constants.constant_multiname.length - 1);
            }
        }
        return 0;
    }

    public Object getElementAt(int index) {
        switch (this.type) {
            case 0: {
                return "" + (index + 1) + ":" + this.constants.constant_uint[index + 1];
            }
            case 1: {
                return "" + (index + 1) + ":" + this.constants.constant_int[index + 1];
            }
            case 2: {
                return "" + (index + 1) + ":" + this.constants.constant_double[index + 1];
            }
            case 3: {
                return "" + (index + 1) + ":" + this.constants.constant_decimal[index + 1];
            }
            case 4: {
                return "" + (index + 1) + ":" + Helper.escapeString(this.constants.constant_string[index + 1]);
            }
            case 5: {
                return "" + (index + 1) + ":" + this.constants.constant_namespace[index + 1].getNameWithKind(this.constants);
            }
            case 6: {
                return "" + (index + 1) + ":" + this.constants.constant_namespace_set[index + 1].toString(this.constants);
            }
            case 7: {
                return "" + (index + 1) + ":" + this.constants.constant_multiname[index + 1].toString(this.constants, new ArrayList<String>());
            }
        }
        return null;
    }

    @Override
    public void addListDataListener(ListDataListener l) {
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
    }
}

