/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.gui;

import com.jpexs.asdec.abc.ABC;
import com.jpexs.asdec.abc.avm2.AVM2Code;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.flowgraph.Graph;
import com.jpexs.asdec.abc.avm2.parser.ASM3Parser;
import com.jpexs.asdec.abc.avm2.parser.ParseException;
import com.jpexs.asdec.abc.gui.DialogMissingSymbolHandler;
import com.jpexs.asdec.abc.gui.GraphFrame;
import com.jpexs.asdec.abc.gui.LineMarkedEditorPane;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class ASMSourceEditorPane
extends LineMarkedEditorPane {
    public ABC abc;
    public int bodyIndex = -1;

    public void setBodyIndex(int bodyIndex, ABC abc) {
        this.bodyIndex = bodyIndex;
        this.abc = abc;
        this.setText(abc.bodies[bodyIndex].code.toASMSource(abc.constants, abc.bodies[bodyIndex]));
    }

    public void graph() {
        Graph gr = new Graph(this.abc.bodies[this.bodyIndex].code);
        new GraphFrame(gr, "").setVisible(true);
    }

    public void exec() {
        HashMap<Integer, Object> args = new HashMap<Integer, Object>();
        args.put(0, new Object());
        args.put(1, new Long(466561L));
        Object o = this.abc.bodies[this.bodyIndex].code.execute(args, this.abc.constants);
        JOptionPane.showMessageDialog(this, "Returned object:" + o.toString());
    }

    public boolean save(ConstantPool constants) {
        try {
            AVM2Code acode = ASM3Parser.parse(new ByteArrayInputStream(this.getText().getBytes()), constants, new DialogMissingSymbolHandler(), this.abc.bodies[this.bodyIndex]);
            acode.getBytes(this.abc.bodies[this.bodyIndex].codeBytes);
            this.abc.bodies[this.bodyIndex].code = acode;
        }
        catch (IOException ex) {
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, ex.text + " on line " + ex.line);
            this.selectLine((int)ex.line);
            return false;
        }
        return true;
    }

    public void verify(ConstantPool constants, ABC abc) {
        try {
            AVM2Code acode = ASM3Parser.parse(new ByteArrayInputStream(this.getText().getBytes()), constants, new DialogMissingSymbolHandler(), abc.bodies[this.bodyIndex]);
            this.setText(acode.toASMSource(constants, abc.bodies[this.bodyIndex]));
        }
        catch (IOException ex) {
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, ex.text + " on line " + ex.line);
            this.selectLine((int)ex.line);
            return;
        }
        JOptionPane.showMessageDialog(this, "Code OK");
    }

    public void selectInstruction(int pos) {
        String text = this.getText();
        int lineCnt = 1;
        int lineStart = 0;
        int instrCount = 0;
        int dot = -2;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            ++lineCnt;
            int lineEnd = i;
            String ins = text.substring(lineStart, lineEnd).trim();
            if (!(i > 0 && text.charAt(i - 1) == ':' || ins.startsWith("exception "))) {
                ++instrCount;
            }
            if (instrCount == pos + 1) break;
            lineStart = i + 1;
        }
        if (lineCnt == -1) {
            // empty if block
        }
        this.setCaretPosition(lineStart);
    }

    public void selectLine(int line) {
        String text = this.getText();
        int lineCnt = 1;
        int lineStart = 0;
        int lineEnd = -1;
        for (int i = 0; i < text.length(); ++i) {
            if (text.charAt(i) != '\n') continue;
            if (++lineCnt == line) {
                lineStart = i;
            }
            if (lineCnt != line + 1) continue;
            lineEnd = i;
        }
        if (lineCnt == -1) {
            lineEnd = text.length() - 1;
        }
        this.select(lineStart, lineEnd);
        this.requestFocus();
    }
}

