/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.treemodel.clauses;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.treemodel.ContinueTreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.TreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.clauses.Block;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class IfTreeItem
extends TreeItem
implements Block {
    public TreeItem expression;
    public List<TreeItem> onTrue;
    public List<TreeItem> onFalse;

    public IfTreeItem(AVM2Instruction instruction, TreeItem expression, List<TreeItem> onTrue, List<TreeItem> onFalse) {
        super(instruction, 16);
        this.expression = expression;
        this.onTrue = onTrue;
        this.onFalse = onFalse;
    }

    @Override
    public String toString(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        String ret = this.hilight("if(") + this.expression.toString(constants, localRegNames, fullyQualifiedNames) + this.hilight(")") + "\r\n{\r\n";
        for (TreeItem ti : this.onTrue) {
            ret = ret + ti.toStringSemicoloned(constants, localRegNames, fullyQualifiedNames) + "\r\n";
        }
        ret = ret + this.hilight("}");
        if (this.onFalse.size() > 0) {
            ret = ret + "\r\n" + this.hilight("else") + "\r\n" + this.hilight("{") + "\r\n";
            for (TreeItem ti : this.onFalse) {
                ret = ret + ti.toStringSemicoloned(constants, localRegNames, fullyQualifiedNames) + "\r\n";
            }
            ret = ret + this.hilight("}");
        }
        return ret;
    }

    @Override
    public boolean needsSemicolon() {
        return false;
    }

    @Override
    public List<ContinueTreeItem> getContinues() {
        ArrayList<ContinueTreeItem> ret = new ArrayList<ContinueTreeItem>();
        for (TreeItem ti : this.onTrue) {
            if (ti instanceof ContinueTreeItem) {
                ret.add((ContinueTreeItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        for (TreeItem ti : this.onFalse) {
            if (ti instanceof ContinueTreeItem) {
                ret.add((ContinueTreeItem)ti);
            }
            if (!(ti instanceof Block)) continue;
            ret.addAll(((Block)((Object)ti)).getContinues());
        }
        return ret;
    }
}

