/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.treemodel;

import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.AVM2Instruction;
import com.jpexs.asdec.abc.avm2.treemodel.FindPropertyTreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.FullMultinameTreeItem;
import com.jpexs.asdec.abc.avm2.treemodel.LocalRegTreeItem;
import com.jpexs.asdec.helpers.Highlighting;
import java.util.HashMap;
import java.util.List;

public abstract class TreeItem {
    public static final int PRECEDENCE_PRIMARY = 0;
    public static final int PRECEDENCE_POSTFIX = 1;
    public static final int PRECEDENCE_UNARY = 2;
    public static final int PRECEDENCE_MULTIPLICATIVE = 3;
    public static final int PRECEDENCE_ADDITIVE = 4;
    public static final int PRECEDENCE_BITWISESHIFT = 5;
    public static final int PRECEDENCE_RELATIONAL = 6;
    public static final int PRECEDENCE_EQUALITY = 7;
    public static final int PRECEDENCE_BITWISEAND = 8;
    public static final int PRECEDENCE_BITWISEXOR = 9;
    public static final int PRECEDENCE_BITWISEOR = 10;
    public static final int PRECEDENCE_LOGICALAND = 11;
    public static final int PRECEDENCE_LOGICALOR = 12;
    public static final int PRECEDENCE_CONDITIONAL = 13;
    public static final int PRECEDENCE_ASSIGMENT = 14;
    public static final int PRECEDENCE_COMMA = 15;
    public static final int NOPRECEDENCE = 16;
    public int precedence = 16;
    public AVM2Instruction instruction;
    public boolean hidden = false;

    public TreeItem(AVM2Instruction instruction, int precedence) {
        this.instruction = instruction;
        this.precedence = precedence;
    }

    public abstract String toString(ConstantPool var1, HashMap<Integer, String> var2, List<String> var3);

    public String toStringNoH(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        return Highlighting.stripHilights(this.toString(constants, localRegNames, fullyQualifiedNames));
    }

    public String toStringSemicoloned(ConstantPool constants, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        return this.toString(constants, localRegNames, fullyQualifiedNames) + (this.needsSemicolon() ? ";" : "");
    }

    public boolean needsSemicolon() {
        return true;
    }

    protected String hilight(String str) {
        if (this.instruction == null) {
            return str;
        }
        return Highlighting.hilighOffset(str, this.instruction.offset);
    }

    public boolean isFalse() {
        return false;
    }

    public boolean isTrue() {
        return false;
    }

    protected String formatProperty(ConstantPool constants, TreeItem object, TreeItem propertyName, HashMap<Integer, String> localRegNames, List<String> fullyQualifiedNames) {
        String obStr = object.toString(constants, localRegNames, fullyQualifiedNames);
        if (object.precedence > 0) {
            obStr = "(" + obStr + ")";
        }
        if (object instanceof LocalRegTreeItem && ((LocalRegTreeItem)object).computedValue instanceof FindPropertyTreeItem) {
            obStr = "";
        }
        if (obStr.equals("")) {
            return propertyName.toString(constants, localRegNames, fullyQualifiedNames);
        }
        if (propertyName instanceof FullMultinameTreeItem) {
            if (((FullMultinameTreeItem)propertyName).isRuntime()) {
                return this.joinProperty(obStr, propertyName.toString(constants, localRegNames, fullyQualifiedNames));
            }
            return this.joinProperty(obStr, ((FullMultinameTreeItem)propertyName).toString(constants, localRegNames, fullyQualifiedNames));
        }
        return obStr + "[" + propertyName.toString(constants, localRegNames, fullyQualifiedNames) + "]";
    }

    private String joinProperty(String prefix, String name) {
        if (prefix.endsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!Highlighting.stripHilights(name).startsWith("[")) {
            return prefix + "." + name;
        }
        return prefix + name;
    }

    public TreeItem getNotCoerced() {
        return this;
    }

    public TreeItem getThroughRegister() {
        return this;
    }

    public static String localRegName(HashMap<Integer, String> localRegNames, int reg) {
        if (localRegNames.containsKey(reg)) {
            return localRegNames.get(reg);
        }
        if (reg == 0) {
            return "this";
        }
        return "_loc" + reg + "_";
    }
}

