/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec.abc.avm2.instructions;

import com.jpexs.asdec.abc.ABCOutputStream;
import com.jpexs.asdec.abc.avm2.ConstantPool;
import com.jpexs.asdec.abc.avm2.instructions.InstructionDefinition;
import com.jpexs.asdec.helpers.Helper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AVM2Instruction {
    public InstructionDefinition definition;
    public int[] operands;
    public long offset;
    public byte[] bytes;
    public String comment;
    public boolean ignored = false;

    public AVM2Instruction(long offset, InstructionDefinition definition, int[] operands, byte[] bytes) {
        this.definition = definition;
        this.operands = operands;
        this.offset = offset;
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ABCOutputStream aos = new ABCOutputStream(bos);
            aos.write(this.definition.instructionCode);
            block9: for (int i = 0; i < this.definition.operands.length; ++i) {
                int opt = this.definition.operands[i] & 0xFF00;
                switch (opt) {
                    case 768: {
                        aos.writeS24(this.operands[i]);
                        continue block9;
                    }
                    case 256: {
                        aos.writeU30(this.operands[i]);
                        continue block9;
                    }
                    case 512: {
                        aos.writeU8(this.operands[i]);
                        continue block9;
                    }
                    case 1280: {
                        aos.writeU8(0xFF & this.operands[i]);
                        continue block9;
                    }
                    case 1024: {
                        aos.writeU30(this.operands[i]);
                        for (int j = i + 1; j < this.operands.length; ++j) {
                            aos.writeS24(this.operands[j]);
                        }
                        continue block9;
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public String toString() {
        String s = this.definition.instructionName;
        for (int i = 0; i < this.operands.length; ++i) {
            s = s + " " + this.operands[i];
        }
        return s;
    }

    public List<Long> getOffsets() {
        ArrayList<Long> ret = new ArrayList<Long>();
        String s = "";
        block5: for (int i = 0; i < this.definition.operands.length; ++i) {
            switch (this.definition.operands[i]) {
                case 779: {
                    ret.add(this.offset + (long)this.operands[i] + (long)this.getBytes().length);
                    continue block5;
                }
                case 786: {
                    ret.add(this.offset + (long)this.operands[i]);
                    continue block5;
                }
                case 1024: {
                    for (int j = i + 1; j < this.operands.length; ++j) {
                        ret.add(this.offset + (long)this.operands[j]);
                    }
                    continue block5;
                }
            }
        }
        return ret;
    }

    public List getParamsAsList(ConstantPool constants) {
        ArrayList<Object> s = new ArrayList<Object>();
        block10: for (int i = 0; i < this.definition.operands.length; ++i) {
            switch (this.definition.operands[i]) {
                case 257: {
                    s.add(constants.constant_multiname[this.operands[i]]);
                    continue block10;
                }
                case 260: {
                    s.add(constants.constant_string[this.operands[i]]);
                    continue block10;
                }
                case 270: {
                    s.add(new Long(constants.constant_int[this.operands[i]]));
                    continue block10;
                }
                case 271: {
                    s.add(new Long(constants.constant_uint[this.operands[i]]));
                    continue block10;
                }
                case 272: {
                    s.add(new Double(constants.constant_double[this.operands[i]]));
                    continue block10;
                }
                case 779: {
                    s.add(new Long(this.offset + (long)this.operands[i] + (long)this.getBytes().length));
                    continue block10;
                }
                case 786: {
                    s.add(new Long(this.offset + (long)this.operands[i]));
                    continue block10;
                }
                case 1024: {
                    s.add(new Long(this.operands[i]));
                    for (int j = i + 1; j < this.operands.length; ++j) {
                        s.add(new Long(this.offset + (long)this.operands[j]));
                    }
                    continue block10;
                }
                default: {
                    s.add(new Long(this.operands[i]));
                }
            }
        }
        return s;
    }

    public String getParams(ConstantPool constants, List<String> fullyQualifiedNames) {
        String s = "";
        block10: for (int i = 0; i < this.definition.operands.length; ++i) {
            switch (this.definition.operands[i]) {
                case 257: {
                    s = s + " m[" + this.operands[i] + "]\"" + Helper.escapeString(constants.constant_multiname[this.operands[i]].toString(constants, fullyQualifiedNames)) + "\"";
                    continue block10;
                }
                case 260: {
                    s = s + " \"" + Helper.escapeString(constants.constant_string[this.operands[i]]) + "\"";
                    continue block10;
                }
                case 270: {
                    s = s + " " + constants.constant_int[this.operands[i]] + "";
                    continue block10;
                }
                case 271: {
                    s = s + " " + constants.constant_uint[this.operands[i]] + "";
                    continue block10;
                }
                case 272: {
                    s = s + " " + constants.constant_double[this.operands[i]] + "";
                    continue block10;
                }
                case 779: {
                    s = s + " ";
                    if (this.operands[i] > 0) {
                        // empty if block
                    }
                    s = s + "ofs" + Helper.formatAddress(this.offset + (long)this.operands[i] + (long)this.getBytes().length) + "";
                    continue block10;
                }
                case 786: {
                    s = s + " ";
                    if (this.operands[i] > 0) {
                        // empty if block
                    }
                    s = s + "ofs" + Helper.formatAddress(this.offset + (long)this.operands[i]) + "";
                    continue block10;
                }
                case 1024: {
                    s = s + " " + this.operands[i];
                    for (int j = i + 1; j < this.operands.length; ++j) {
                        s = s + " ";
                        if (this.operands[j] > 0) {
                            // empty if block
                        }
                        s = s + "ofs" + Helper.formatAddress(this.offset + (long)this.operands[j]) + "";
                    }
                    continue block10;
                }
                default: {
                    s = s + " " + this.operands[i];
                }
            }
        }
        return s;
    }

    public String getComment() {
        if (this.ignored) {
            return " ;ignored";
        }
        if (this.comment == null || this.comment.equals("")) {
            return "";
        }
        return " ;" + this.comment;
    }

    public String toString(ConstantPool constants, List<String> fullyQualifiedNames) {
        String s = Helper.formatAddress(this.offset) + " " + Helper.padSpaceRight(Helper.byteArrToString(this.getBytes()), 30) + this.definition.instructionName;
        s = s + this.getParams(constants, fullyQualifiedNames) + this.getComment();
        return s;
    }

    public String toStringNoAddress(ConstantPool constants, List<String> fullyQualifiedNames) {
        String s = this.definition.instructionName;
        s = s + this.getParams(constants, fullyQualifiedNames) + this.getComment();
        return s;
    }
}

