/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec;

import SevenZip.Compression.LZMA.Decoder;
import SevenZip.Compression.LZMA.Encoder;
import com.jpexs.asdec.EventListener;
import com.jpexs.asdec.PercentListener;
import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.SWFOutputStream;
import com.jpexs.asdec.action.TagNode;
import com.jpexs.asdec.tags.DefineBitsJPEG2Tag;
import com.jpexs.asdec.tags.DefineBitsJPEG3Tag;
import com.jpexs.asdec.tags.DefineBitsJPEG4Tag;
import com.jpexs.asdec.tags.DefineBitsLossless2Tag;
import com.jpexs.asdec.tags.DefineBitsLosslessTag;
import com.jpexs.asdec.tags.DefineBitsTag;
import com.jpexs.asdec.tags.DoABCTag;
import com.jpexs.asdec.tags.JPEGTablesTag;
import com.jpexs.asdec.tags.Tag;
import com.jpexs.asdec.tags.base.CharacterTag;
import com.jpexs.asdec.types.RECT;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.imageio.ImageIO;

public class SWF {
    public static final int DEFAULT_VERSION = 10;
    public List<Tag> tags = new ArrayList<Tag>();
    public RECT displayRect;
    public int frameRate;
    public int frameCount;
    public int version;
    public long fileSize;
    public boolean compressed = false;
    public boolean lzma = false;
    public long compressedSize;
    public byte[] lzmaProperties;
    protected HashSet<EventListener> listeners = new HashSet();

    public List<Tag> getTagData(int tagId) {
        ArrayList<Tag> ret = new ArrayList<Tag>();
        for (Tag tag : this.tags) {
            if (tag.getId() != tagId) continue;
            ret.add(tag);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(OutputStream os) throws IOException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SWFOutputStream sos = new SWFOutputStream(baos, this.version);
            sos.writeRECT(this.displayRect);
            sos.writeUI8(0);
            sos.writeUI8(this.frameRate);
            sos.writeUI16(this.frameCount);
            sos.writeTags(this.tags);
            sos.writeUI16(0);
            sos.close();
            if (this.compressed && this.lzma) {
                os.write(90);
            } else if (this.compressed) {
                os.write(67);
            } else {
                os.write(70);
            }
            os.write(87);
            os.write(83);
            os.write(this.version);
            byte[] data = baos.toByteArray();
            sos = new SWFOutputStream(os, this.version);
            sos.writeUI32(data.length + 8);
            if (this.compressed) {
                if (this.lzma) {
                    Encoder enc = new Encoder();
                    int val = this.lzmaProperties[0] & 0xFF;
                    int lc = val % 9;
                    int remainder = val / 9;
                    int lp = remainder % 5;
                    int pb = remainder / 5;
                    int dictionarySize = 0;
                    for (int i = 0; i < 4; ++i) {
                        dictionarySize += (this.lzmaProperties[1 + i] & 0xFF) << i * 8;
                    }
                    enc.SetDictionarySize(dictionarySize);
                    enc.SetLcLpPb(lc, lp, pb);
                    baos = new ByteArrayOutputStream();
                    enc.SetEndMarkerMode(true);
                    enc.Code(new ByteArrayInputStream(data), baos, -1L, -1L, null);
                    data = baos.toByteArray();
                    byte[] udata = new byte[]{(byte)(data.length & 0xFF), (byte)(data.length >> 8 & 0xFF), (byte)(data.length >> 16 & 0xFF), (byte)(data.length >> 24 & 0xFF)};
                    os.write(udata);
                    os.write(this.lzmaProperties);
                } else {
                    os = new DeflaterOutputStream(os);
                }
            }
            os.write(data);
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public SWF(InputStream is) throws IOException {
        this(is, null);
    }

    public SWF(InputStream is, PercentListener listener) throws IOException {
        byte[] hdr = new byte[3];
        is.read(hdr);
        String shdr = new String(hdr);
        if (!(shdr.equals("FWS") || shdr.equals("CWS") || shdr.equals("ZWS"))) {
            throw new IOException("Invalid SWF file");
        }
        this.version = is.read();
        SWFInputStream sis = new SWFInputStream(is, this.version, 4L);
        this.fileSize = sis.readUI32();
        if (hdr[0] == 67) {
            sis = new SWFInputStream(new InflaterInputStream(is), this.version, 8L);
            this.compressed = true;
        }
        if (hdr[0] == 90) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            long outSize = sis.readUI32();
            int propertiesSize = 5;
            this.lzmaProperties = new byte[propertiesSize];
            if (sis.read(this.lzmaProperties, 0, propertiesSize) != propertiesSize) {
                throw new IOException("LZMA:input .lzma file is too short");
            }
            Decoder decoder = new Decoder();
            if (!decoder.SetDecoderProperties(this.lzmaProperties)) {
                throw new IOException("LZMA:Incorrect stream properties");
            }
            if (!decoder.Code(sis, baos, this.fileSize - 8L)) {
                throw new IOException("LZMA:Error in data stream");
            }
            sis = new SWFInputStream(new ByteArrayInputStream(baos.toByteArray()), this.version, 8L);
            this.compressed = true;
            this.lzma = true;
        }
        if (listener != null) {
            sis.addPercentListener(listener);
        }
        sis.setPercentMax(this.fileSize);
        this.displayRect = sis.readRECT();
        int tmpFirstByetOfFrameRate = sis.readUI8();
        this.frameRate = sis.readUI8();
        this.frameCount = sis.readUI16();
        this.tags = sis.readTagList(0);
    }

    public static boolean fws2cws(InputStream fis, OutputStream fos) {
        try {
            int i;
            byte[] swfHead = new byte[8];
            fis.read(swfHead);
            if (swfHead[0] != 70) {
                fis.close();
                return false;
            }
            swfHead[0] = 67;
            fos.write(swfHead);
            fos = new DeflaterOutputStream(fos);
            while ((i = fis.read()) != -1) {
                fos.write(i);
            }
            fis.close();
            fos.close();
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean cws2fws(InputStream fis, OutputStream fos) {
        try {
            int i;
            byte[] swfHead = new byte[8];
            fis.read(swfHead);
            InflaterInputStream iis = new InflaterInputStream(fis);
            if (swfHead[0] != 67) {
                fis.close();
                return false;
            }
            swfHead[0] = 70;
            fos.write(swfHead);
            while ((i = iis.read()) != -1) {
                fos.write(i);
            }
            fis.close();
            fos.close();
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public static boolean zws2fws(InputStream fis, OutputStream fos) {
        try {
            ByteArrayOutputStream baos;
            byte[] hdr = new byte[3];
            fis.read(hdr);
            String shdr = new String(hdr);
            if (!shdr.equals("ZWS")) {
                return false;
            }
            int version = fis.read();
            SWFInputStream sis = new SWFInputStream(fis, version, 4L);
            long fileSize = sis.readUI32();
            if (hdr[0] == 90) {
                baos = new ByteArrayOutputStream();
                long outSize = sis.readUI32();
                int propertiesSize = 5;
                byte[] lzmaProperties = new byte[propertiesSize];
                if (sis.read(lzmaProperties, 0, propertiesSize) != propertiesSize) {
                    throw new IOException("LZMA:input .lzma file is too short");
                }
                Decoder decoder = new Decoder();
                if (!decoder.SetDecoderProperties(lzmaProperties)) {
                    throw new IOException("LZMA:Incorrect stream properties");
                }
                if (!decoder.Code(sis, baos, fileSize - 8L)) {
                    throw new IOException("LZMA:Error in data stream");
                }
            } else {
                return false;
            }
            SWFOutputStream sos = new SWFOutputStream(fos, version);
            sos.write("FWS".getBytes());
            sos.write(version);
            sos.writeUI32(fileSize);
            sos.write(baos.toByteArray());
            sos.close();
        }
        catch (FileNotFoundException ex) {
            return false;
        }
        catch (IOException ex) {
            return false;
        }
        return true;
    }

    public boolean exportActionScript(String outdir, boolean isPcode) throws Exception {
        boolean asV3Found = false;
        EventListener evl = new EventListener(){

            @Override
            public void handleEvent(String event, Object data) {
                if (event.equals("export")) {
                    SWF.this.informListeners(event, data);
                }
            }
        };
        ArrayList<DoABCTag> abcTags = new ArrayList<DoABCTag>();
        for (Tag tag : this.tags) {
            if (!(tag instanceof DoABCTag)) continue;
            abcTags.add((DoABCTag)tag);
            asV3Found = true;
        }
        for (int i = 0; i < abcTags.size(); ++i) {
            DoABCTag doABCTag = (DoABCTag)abcTags.get(i);
            doABCTag.abc.addEventListener(evl);
            doABCTag.abc.export(outdir, isPcode, abcTags, "tag " + (i + 1) + "/" + abcTags.size() + " ");
        }
        for (DoABCTag doABCTag : abcTags) {
        }
        if (!asV3Found) {
            ArrayList<Object> list2 = new ArrayList<Object>();
            list2.addAll(this.tags);
            List<TagNode> list = TagNode.createTagList(list2);
            TagNode.setExport(list, true);
            return TagNode.exportNode(list, outdir, isPcode);
        }
        return asV3Found;
    }

    public void addEventListener(EventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(EventListener listener) {
        this.listeners.remove(listener);
    }

    protected void informListeners(String event, Object data) {
        for (EventListener listener : this.listeners) {
            listener.handleEvent(event, data);
        }
    }

    private static String getImageFormat(byte[] data) {
        if (SWF.hasErrorHeader(data)) {
            return "jpg";
        }
        if (data.length > 2 && (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 216) {
            return "jpg";
        }
        if (data.length > 6 && (data[0] & 0xFF) == 71 && (data[1] & 0xFF) == 73 && (data[2] & 0xFF) == 70 && (data[3] & 0xFF) == 56 && (data[4] & 0xFF) == 57 && (data[5] & 0xFF) == 97) {
            return "gif";
        }
        if (data.length > 8 && (data[0] & 0xFF) == 137 && (data[1] & 0xFF) == 80 && (data[2] & 0xFF) == 78 && (data[3] & 0xFF) == 71 && (data[4] & 0xFF) == 13 && (data[5] & 0xFF) == 10 && (data[6] & 0xFF) == 26 && (data[7] & 0xFF) == 10) {
            return "png";
        }
        return "unk";
    }

    public static boolean hasErrorHeader(byte[] data) {
        return data.length > 4 && (data[0] & 0xFF) == 255 && (data[1] & 0xFF) == 217 && (data[2] & 0xFF) == 255 && (data[3] & 0xFF) == 216;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportImages(String outdir, List<Tag> tags, JPEGTablesTag jtt) throws IOException {
        for (Tag t : tags) {
            CharacterTag dbl;
            if (t instanceof DefineBitsJPEG2Tag || t instanceof DefineBitsJPEG3Tag || t instanceof DefineBitsJPEG4Tag) {
                byte[] imageData = null;
                int characterID = 0;
                if (t instanceof DefineBitsJPEG2Tag) {
                    imageData = ((DefineBitsJPEG2Tag)t).imageData;
                    characterID = ((DefineBitsJPEG2Tag)t).characterID;
                }
                if (t instanceof DefineBitsJPEG3Tag) {
                    imageData = ((DefineBitsJPEG3Tag)t).imageData;
                    characterID = ((DefineBitsJPEG3Tag)t).characterID;
                }
                if (t instanceof DefineBitsJPEG4Tag) {
                    imageData = ((DefineBitsJPEG4Tag)t).imageData;
                    characterID = ((DefineBitsJPEG4Tag)t).characterID;
                }
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(outdir + File.separator + characterID + "." + SWF.getImageFormat(imageData));
                    if (SWF.hasErrorHeader(imageData)) {
                        fos.write(imageData, 4, imageData.length - 4);
                    } else {
                        fos.write(imageData);
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            if (t instanceof DefineBitsLosslessTag) {
                dbl = (DefineBitsLosslessTag)t;
                ImageIO.write((RenderedImage)((DefineBitsLosslessTag)dbl).getImage(), "PNG", new File(outdir + File.separator + ((DefineBitsLosslessTag)dbl).characterID + ".png"));
            }
            if (t instanceof DefineBitsLossless2Tag) {
                dbl = (DefineBitsLossless2Tag)t;
                ImageIO.write((RenderedImage)((DefineBitsLossless2Tag)dbl).getImage(), "PNG", new File(outdir + File.separator + ((DefineBitsLossless2Tag)dbl).characterID + ".png"));
            }
            if (jtt == null || !(t instanceof DefineBitsTag)) continue;
            DefineBitsTag dbt = (DefineBitsTag)t;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(outdir + File.separator + dbt.characterID + ".jpg");
                fos.write(dbt.getFullImageData(jtt));
            }
            finally {
                if (fos == null) continue;
                try {
                    fos.close();
                }
                catch (Exception ex) {}
            }
        }
    }

    public void exportImages(String outdir) throws IOException {
        JPEGTablesTag jtt = null;
        for (Tag t : this.tags) {
            if (!(t instanceof JPEGTablesTag)) continue;
            jtt = (JPEGTablesTag)t;
        }
        SWF.exportImages(outdir, this.tags, jtt);
    }
}

