/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec;

import com.jpexs.asdec.Configuration;
import com.jpexs.asdec.EventListener;
import com.jpexs.asdec.PercentListener;
import com.jpexs.asdec.SWF;
import com.jpexs.asdec.SWFInputStream;
import com.jpexs.asdec.abc.avm2.AVM2Code;
import com.jpexs.asdec.gui.AboutDialog;
import com.jpexs.asdec.gui.LoadingDialog;
import com.jpexs.asdec.gui.MainFrame;
import com.jpexs.asdec.gui.ModeFrame;
import com.jpexs.asdec.gui.View;
import com.jpexs.asdec.gui.proxy.ProxyFrame;
import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.Socket;
import java.net.URI;
import java.util.Calendar;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Main {
    public static ProxyFrame proxyFrame;
    public static String file;
    public static String maskURL;
    public static SWF swf;
    public static final String version = "1.2.0u1";
    public static final String applicationName = "JP ActionScript Decompiler v.1.2.0u1";
    public static final String shortApplicationName = "ASDec";
    public static final String shortApplicationVerName = "ASDec v.1.2.0u1";
    public static final String projectPage = "http://code.google.com/p/asdec/";
    public static LoadingDialog loadingDialog;
    public static ModeFrame modeFrame;
    private static boolean working;
    private static TrayIcon trayIcon;
    private static MenuItem stopMenuItem;
    private static boolean commandLineMode;
    public static MainFrame mainFrame;
    public static boolean DEBUG_COPY;
    public static boolean debugMode;
    public static boolean DISABLE_DANGEROUS;
    public static final boolean RESOLVE_CONSTANTS = true;
    public static final boolean DO_DECOMPILE = true;
    public static final boolean LATEST_CONSTANTPOOL_HACK = false;
    public static boolean dump_tags;
    public static final int SUBLIMITER = 500;
    public static final boolean PARAM_NAMES_ENABLE = false;

    public static boolean isCommandLineMode() {
        return commandLineMode;
    }

    public static String getFileTitle() {
        if (maskURL != null) {
            return maskURL;
        }
        return file;
    }

    public static void setSubLimiter(boolean value) {
        AVM2Code.toSourceLimit = value ? 500 : -1;
    }

    public static boolean isWorking() {
        return working;
    }

    public static void showProxy() {
        if (proxyFrame == null) {
            proxyFrame = new ProxyFrame();
        }
        proxyFrame.setVisible(true);
        proxyFrame.setState(0);
    }

    public static void startWork(String name) {
        Main.startWork(name, -1);
    }

    public static void startWork(String name, int percent) {
        working = true;
        if (mainFrame != null) {
            mainFrame.setStatus(name);
            if (percent == -1) {
                mainFrame.hidePercent();
            } else {
                mainFrame.setPercent(percent);
            }
        }
        if (loadingDialog != null) {
            loadingDialog.setDetail(name);
            if (percent == -1) {
                loadingDialog.hidePercent();
            } else {
                loadingDialog.setPercent(percent);
            }
        }
        if (Main.isCommandLineMode()) {
            System.out.println(name);
        }
    }

    public static void stopWork() {
        working = false;
        if (mainFrame != null) {
            mainFrame.setStatus("");
        }
        if (loadingDialog != null) {
            loadingDialog.setDetail("");
        }
    }

    public static SWF parseSWF(String file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        SWF locswf = new SWF(bis, new PercentListener(){

            @Override
            public void percent(int p) {
                Main.startWork("Reading SWF", p);
            }
        });
        locswf.addEventListener(new EventListener(){

            @Override
            public void handleEvent(String event, Object data) {
                if (event.equals("export")) {
                    Main.startWork((String)data);
                }
            }
        });
        return locswf;
    }

    public static void saveFile(String outfile) throws IOException {
        file = outfile;
        swf.saveTo(new FileOutputStream(outfile));
    }

    public static boolean openFile(String swfFile) {
        if (mainFrame != null) {
            mainFrame.setVisible(false);
        }
        file = swfFile;
        if (loadingDialog == null) {
            loadingDialog = new LoadingDialog();
        }
        loadingDialog.setVisible(true);
        new OpenFileWorker().execute();
        return true;
    }

    public static boolean saveFileDialog() {
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File((String)Configuration.getConfig("lastSaveDir", ".")));
        JFrame f = new JFrame();
        View.setWindowIcon(f);
        int returnVal = fc.showSaveDialog(f);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            try {
                Main.saveFile(file.getAbsolutePath());
                Configuration.setConfig("lastSaveDir", file.getParentFile().getAbsolutePath());
                maskURL = null;
                return true;
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot write to the file");
            }
        }
        return false;
    }

    public static boolean openFileDialog() {
        maskURL = null;
        JFileChooser fc = new JFileChooser();
        fc.setCurrentDirectory(new File((String)Configuration.getConfig("lastOpenDir", ".")));
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(".swf") || f.isDirectory();
            }

            @Override
            public String getDescription() {
                return "SWF files (*.swf)";
            }
        });
        JFrame f = new JFrame();
        View.setWindowIcon(f);
        int returnVal = fc.showOpenDialog(f);
        if (returnVal == 0) {
            Configuration.setConfig("lastOpenDir", fc.getSelectedFile().getParentFile().getAbsolutePath());
            File selfile = fc.getSelectedFile();
            Main.openFile(selfile.getAbsolutePath());
            return true;
        }
        return false;
    }

    public static void showModeFrame() {
        if (modeFrame == null) {
            modeFrame = new ModeFrame();
        }
        modeFrame.setVisible(true);
    }

    public static void updateLicenseInDir(File dir) {
        File[] files;
        int defaultStartYear = 2010;
        int defaultFinalYear = 2013;
        String defaultAuthor = "JPEXS";
        String defaultYearStr = "" + defaultStartYear;
        if (defaultFinalYear != defaultStartYear) {
            defaultYearStr = defaultYearStr + "-" + defaultFinalYear;
        }
        String license = "/*\r\n *  Copyright (C) {year} {author}\r\n * \r\n *  This program is free software: you can redistribute it and/or modify\r\n *  it under the terms of the GNU General Public License as published by\r\n *  the Free Software Foundation, either version 3 of the License, or\r\n *  (at your option) any later version.\r\n * \r\n *  This program is distributed in the hope that it will be useful,\r\n *  but WITHOUT ANY WARRANTY; without even the implied warranty of\r\n *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\r\n *  GNU General Public License for more details.\r\n * \r\n *  You should have received a copy of the GNU General Public License\r\n *  along with this program.  If not, see <http://www.gnu.org/licenses/>.\r\n */\r\n\r\n";
        for (File f : files = dir.listFiles()) {
            if (f.isDirectory()) {
                Main.updateLicenseInDir(f);
                continue;
            }
            if (!f.getName().endsWith(".java")) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter pw = null;
            try {
                pw = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "utf8"));
            }
            catch (UnsupportedEncodingException ex) {
                // empty catch block
            }
            try {
                String s;
                BufferedReader br = new BufferedReader(new FileReader(f));
                boolean packageFound = false;
                String author = defaultAuthor;
                String yearStr = defaultYearStr;
                while ((s = br.readLine()) != null) {
                    if (!packageFound) {
                        if (s.trim().startsWith("package")) {
                            packageFound = true;
                            pw.println(license.replace("{year}", yearStr).replace("{author}", author));
                        } else {
                            Matcher mAuthor = Pattern.compile("^.*Copyright \\(C\\) ([0-9]+)(-[0-9]+)? (.*)$").matcher(s);
                            if (mAuthor.matches()) {
                                author = mAuthor.group(3).trim();
                                int startYear = Integer.parseInt(mAuthor.group(1).trim());
                                yearStr = startYear == defaultFinalYear ? "" + startYear : "" + startYear + "-" + defaultFinalYear;
                                if (!author.equals(defaultAuthor)) {
                                    System.out.println("Detected nodefault author:" + author + " in " + f.getAbsolutePath());
                                }
                            }
                        }
                    }
                    if (!packageFound) continue;
                    pw.println(s);
                }
                br.close();
                pw.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
            try {
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(baos.toByteArray());
                fos.close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
    }

    public static void badArguments() {
        System.err.println("Error: Bad Commandline Arguments!");
        Main.printCmdLineUsage();
        System.exit(1);
    }

    public static void printHeader() {
        System.out.println(applicationName);
        for (int i = 0; i < applicationName.length(); ++i) {
            System.out.print("-");
        }
        System.out.println();
    }

    public static void printCmdLineUsage() {
        System.out.println("Commandline arguments:");
        System.out.println(" 1) -help | --help | /?");
        System.out.println(" ...shows commandline arguments (this help)");
        System.out.println(" 2) infile");
        System.out.println(" ...opens SWF file with the decompiler GUI");
        System.out.println(" 3) -proxy (-PXXX)");
        System.out.println("  ...auto start proxy in the tray. Optional parameter -P specifies port for proxy. Defaults to 55555. ");
        System.out.println(" 4) -export (as|pcode|image) outdirectory infile");
        System.out.println("  ...export infile sources to outdirectory as AsctionScript code (\"as\" argument) or as PCode (\"pcode\" argument) or images");
        System.out.println(" 5) -dumpSWF infile");
        System.out.println("  ...dumps list of SWF tags to console");
        System.out.println(" 6) -compress infile outfile");
        System.out.println("  ...Compress SWF infile and save it to outfile");
        System.out.println(" 7) -decompress infile outfile");
        System.out.println("  ...Decompress infile and save it to outfile");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("java -jar ASDec.jar myfile.swf");
        System.out.println("java -jar ASDec.jar -proxy");
        System.out.println("java -jar ASDec.jar -proxy -P1234");
        System.out.println("java -jar ASDec.jar -export as \"C:\\decompiled\\\" myfile.swf");
        System.out.println("java -jar ASDec.jar -export pcode \"C:\\decompiled\\\" myfile.swf");
        System.out.println("java -jar ASDec.jar -dumpSWF myfile.swf");
        System.out.println("java -jar ASDec.jar -compress myfile.swf myfiledec.swf");
        System.out.println("java -jar ASDec.jar -decompress myfiledec.swf myfile.swf");
    }

    private static void copyFile(String from, String to) throws IOException {
        FileInputStream fis = new FileInputStream(from);
        FileOutputStream fos = new FileOutputStream(to);
        byte[] buf = new byte[4096];
        int cnt = 0;
        while ((cnt = fis.read(buf)) > 0) {
            fos.write(buf, 0, cnt);
        }
        fis.close();
        fos.close();
    }

    public static void restartApplication(String[] args) {
        StringBuilder cmd = new StringBuilder();
        cmd.append(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java ");
        for (String jvmArg : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
            cmd.append(jvmArg + " ");
        }
        cmd.append("-cp ").append(ManagementFactory.getRuntimeMXBean().getClassPath()).append(" ");
        cmd.append(Main.class.getName()).append(" ");
        for (String arg : args) {
            cmd.append(arg).append(" ");
        }
        try {
            Runtime.getRuntime().exec(cmd.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.exit(0);
    }

    public static void checkSWT(String[] args) {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
            return;
        }
        String lastBits = (String)Configuration.getConfig("bits", "-");
        if (!System.getProperty("sun.arch.data.model").equals(lastBits) || !new File("lib/swt.jar").exists()) {
            try {
                if (System.getProperty("sun.arch.data.model").equals("32")) {
                    Main.copyFile("lib/swt32.jar", "lib/swt.jar");
                } else if (System.getProperty("sun.arch.data.model").equals("64")) {
                    Main.copyFile("lib/swt64.jar", "lib/swt.jar");
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, "Cannot copy SWT library.\nPlease make application directory writeable.\n(Placing outside of Program files may help)", "Error", 0);
                Logger.getLogger(SWFInputStream.class.getName()).severe("Cannot copy SWT library");
                System.exit(1);
            }
            Configuration.setConfig("bits", System.getProperty("sun.arch.data.model"));
            Configuration.save();
            Main.restartApplication(args);
        }
    }

    public static void main(String[] args) throws IOException {
        View.setLookAndFeel();
        Configuration.load();
        Main.checkSWT(args);
        int pos = 0;
        if (args.length > 0 && args[0].equals("-debug")) {
            debugMode = true;
            ++pos;
        }
        Main.initLogging(debugMode);
        if (args.length < pos + 1) {
            Main.autoCheckForUpdates();
            Main.showModeFrame();
        } else if (args[pos].equals("-proxy")) {
            int port = 55555;
            for (int i = pos; i < args.length; ++i) {
                if (!args[i].startsWith("-P")) continue;
                try {
                    port = Integer.parseInt(args[pos].substring(2));
                    continue;
                }
                catch (NumberFormatException nex) {
                    System.err.println("Bad port number");
                }
            }
            if (proxyFrame == null) {
                proxyFrame = new ProxyFrame();
            }
            proxyFrame.setPort(port);
            Main.addTrayIcon();
            Main.switchProxy();
        } else if (args[pos].equals("-export")) {
            boolean exportOK;
            String exportFormat;
            if (args.length < pos + 4) {
                Main.badArguments();
            }
            if (!((exportFormat = args[pos + 1]).toLowerCase().equals("as") || exportFormat.toLowerCase().equals("pcode") || exportFormat.toLowerCase().equals("image"))) {
                System.err.println("Invalid export format:" + exportFormat);
                Main.badArguments();
            }
            File outDir = new File(args[pos + 2]);
            File inFile = new File(args[pos + 3]);
            if (!inFile.exists()) {
                System.err.println("Input SWF file does not exist!");
                Main.badArguments();
            }
            commandLineMode = true;
            try {
                Main.printHeader();
                dump_tags = true;
                SWF exfile = new SWF(new FileInputStream(inFile));
                exfile.addEventListener(new EventListener(){

                    @Override
                    public void handleEvent(String event, Object data) {
                        if (event.equals("export")) {
                            System.out.println((String)data);
                        }
                    }
                });
                if (exportFormat.equals("image")) {
                    exfile.exportImages(outDir.getAbsolutePath());
                    exportOK = true;
                } else {
                    exportOK = exportFormat.equals("as") || exportFormat.equals("pcode") ? exfile.exportActionScript(outDir.getAbsolutePath(), exportFormat.equals("pcode")) : false;
                }
            }
            catch (Exception ex) {
                exportOK = false;
                System.err.print("FAIL: Exporting Failed on Exception - ");
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(1);
            }
            if (exportOK) {
                System.out.println("OK");
                System.exit(0);
            } else {
                System.err.println("FAIL");
                System.exit(1);
            }
        } else if (args[pos].equals("-compress")) {
            if (args.length < pos + 3) {
                Main.badArguments();
            }
            if (SWF.fws2cws(new FileInputStream(args[pos + 1]), new FileOutputStream(args[pos + 2]))) {
                System.out.println("OK");
            } else {
                System.err.println("FAIL");
            }
        } else if (args[pos].equals("-decompress")) {
            if (args.length < pos + 3) {
                Main.badArguments();
            }
            if (SWF.cws2fws(new FileInputStream(args[pos + 1]), new FileOutputStream(args[pos + 2]))) {
                System.out.println("OK");
                System.exit(0);
            } else {
                System.err.println("FAIL");
                System.exit(1);
            }
        } else if (args[pos].equals("-dumpSWF")) {
            if (args.length < pos + 2) {
                Main.badArguments();
            }
            try {
                dump_tags = true;
                SWF swf = Main.parseSWF(args[pos + 1]);
            }
            catch (Exception ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                System.exit(1);
            }
            System.exit(0);
        } else if (args[pos].equals("-help") || args[pos].equals("--help") || args[pos].equals("/?")) {
            Main.printHeader();
            Main.printCmdLineUsage();
            System.exit(0);
        } else if (args.length == pos + 1) {
            Main.autoCheckForUpdates();
            Main.openFile(args[pos]);
        } else {
            Main.badArguments();
        }
    }

    public static String tempFile(String url) {
        File f = new File(Configuration.getASDecHome() + "saved" + File.separator);
        if (!f.exists()) {
            f.mkdirs();
        }
        return Configuration.getASDecHome() + "saved" + File.separator + "asdec_" + Integer.toHexString(url.hashCode()) + ".tmp";
    }

    public static void removeTrayIcon() {
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            if (trayIcon != null) {
                tray.remove(trayIcon);
                trayIcon = null;
            }
        }
    }

    public static void switchProxy() {
        proxyFrame.switchState();
        if (stopMenuItem != null) {
            if (proxyFrame.isRunning()) {
                stopMenuItem.setLabel("Stop proxy");
            } else {
                stopMenuItem.setLabel("Start proxy");
            }
        }
    }

    public static void addTrayIcon() {
        if (trayIcon != null) {
            return;
        }
        if (SystemTray.isSupported()) {
            SystemTray tray = SystemTray.getSystemTray();
            trayIcon = new TrayIcon(View.loadImage("com/jpexs/asdec/gui/graphics/proxy16.png"), "JP ASDec Proxy");
            trayIcon.setImageAutoSize(true);
            PopupMenu trayPopup = new PopupMenu();
            ActionListener trayListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("EXIT")) {
                        Main.exit();
                    }
                    if (e.getActionCommand().equals("SHOW")) {
                        Main.showProxy();
                    }
                    if (e.getActionCommand().equals("SWITCH")) {
                        Main.switchProxy();
                    }
                }
            };
            MenuItem showMenuItem = new MenuItem("Show proxy");
            showMenuItem.setActionCommand("SHOW");
            showMenuItem.addActionListener(trayListener);
            trayPopup.add(showMenuItem);
            stopMenuItem = new MenuItem("Start proxy");
            stopMenuItem.setActionCommand("SWITCH");
            stopMenuItem.addActionListener(trayListener);
            trayPopup.add(stopMenuItem);
            trayPopup.addSeparator();
            MenuItem exitMenuItem = new MenuItem("Exit");
            exitMenuItem.setActionCommand("EXIT");
            exitMenuItem.addActionListener(trayListener);
            trayPopup.add(exitMenuItem);
            trayIcon.setPopupMenu(trayPopup);
            trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getButton() == 1) {
                        Main.showProxy();
                    }
                }
            });
            try {
                tray.add(trayIcon);
            }
            catch (AWTException ex) {
                // empty catch block
            }
        }
    }

    public static void exit() {
        Configuration.save();
        System.exit(0);
    }

    public static void about() {
        new AboutDialog().setVisible(true);
    }

    public static void autoCheckForUpdates() {
        Calendar lastUpdatesCheckDate = (Calendar)Configuration.getConfig("lastUpdatesCheckDate", null);
        if (lastUpdatesCheckDate == null || lastUpdatesCheckDate.getTime().getTime() < Calendar.getInstance().getTime().getTime() - 86400000L) {
            Main.checkForUpdates();
        }
    }

    public static boolean checkForUpdates() {
        try {
            String s;
            Socket sock = new Socket("code.google.com", 80);
            OutputStream os = sock.getOutputStream();
            os.write("GET /feeds/p/asdec/downloads/basic HTTP/1.1\r\nHost: code.google.com\r\nConnection: close\r\n\r\n".getBytes());
            BufferedReader br = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            String response = "";
            boolean start = false;
            while ((s = br.readLine()) != null) {
                if (start) {
                    response = response + s + "\r\n";
                }
                if (!s.equals("")) continue;
                start = true;
            }
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(response.getBytes()));
            NodeList contents = doc.getElementsByTagName("content");
            for (int i = 0; i < contents.getLength(); ++i) {
                Node nod = contents.item(i);
                String cont = nod.getTextContent().trim();
                String[] parts = cont.split("\n");
                boolean isUpdate = false;
                for (String part : parts) {
                    if (!part.trim().equals("Update")) continue;
                    isUpdate = true;
                    break;
                }
                if (parts.length <= 4 || !isUpdate) continue;
                String downloadName = parts[1];
                String link = parts[parts.length - 2];
                if (!isUpdate) continue;
                String downVersion = "NEW";
                if (downloadName.startsWith("ASDec version ")) {
                    downVersion = downloadName.substring("ASDec version ".length());
                }
                if (!link.startsWith("<a href=\"")) continue;
                link = link.substring(link.indexOf("\"") + 1);
                link = link.substring(0, link.indexOf("\""));
                if (downVersion.equals(version)) continue;
                Desktop desktop = null;
                if (Desktop.isDesktopSupported()) {
                    desktop = Desktop.getDesktop();
                    if (desktop.isSupported(Desktop.Action.BROWSE)) {
                        if (JOptionPane.showConfirmDialog(null, "New version of ASDec is available: " + downloadName + ".\r\nDo you want to go to project web page to download it?", "New version", 0, 1) == 0) {
                            URI uri = new URI(projectPage);
                            desktop.browse(uri);
                        }
                    } else {
                        desktop = null;
                    }
                }
                if (desktop == null) {
                    JOptionPane.showMessageDialog(null, "New version of ASDec is available: " + downloadName + ".\r\nPlease go to " + projectPage + " to download it.", "New version", 1);
                }
                Configuration.setConfig("lastUpdatesCheckDate", Calendar.getInstance());
                return true;
            }
        }
        catch (Exception ex) {
            return false;
        }
        Configuration.setConfig("lastUpdatesCheckDate", Calendar.getInstance());
        return false;
    }

    public static void initLogging(boolean debug) {
        try {
            Logger logger = Logger.getLogger("");
            logger.setLevel(debug ? Level.CONFIG : Level.WARNING);
            FileHandler fileTxt = new FileHandler("log.txt");
            SimpleFormatter formatterTxt = new SimpleFormatter();
            fileTxt.setFormatter(formatterTxt);
            logger.addHandler(fileTxt);
            if (debug) {
                ConsoleHandler conHan = new ConsoleHandler();
                conHan.setFormatter(formatterTxt);
                logger.addHandler(conHan);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Problems with creating the log files");
        }
    }

    static {
        working = false;
        commandLineMode = false;
        DEBUG_COPY = false;
        debugMode = false;
        DISABLE_DANGEROUS = false;
        dump_tags = false;
    }

    private static class OpenFileWorker
    extends SwingWorker {
        private OpenFileWorker() {
        }

        protected Object doInBackground() throws Exception {
            try {
                Main.startWork("Reading SWF...");
                swf = Main.parseSWF(file);
                FileInputStream fis = new FileInputStream(file);
                DEBUG_COPY = true;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DEBUG_COPY = false;
            }
            catch (Exception ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                JOptionPane.showMessageDialog(null, "Cannot load SWF file.");
                loadingDialog.setVisible(false);
                return false;
            }
            try {
                mainFrame = new MainFrame(swf);
                loadingDialog.setVisible(false);
                mainFrame.setVisible(true);
            }
            catch (Exception ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
            return true;
        }
    }
}

