/*
 * Decompiled with CFR 0.152.
 */
package com.jpexs.asdec;

import com.jpexs.asdec.SWFInputStream;
import com.jpexs.proxy.Replacement;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

public class Configuration {
    private static final String CONFIG_NAME = "asdec.cfg";
    private static final String REPLACEMENTS_NAME = "replacements.ini";
    private static HashMap<String, Object> config = new HashMap();
    public static List<Replacement> replacements = new ArrayList<Replacement>();

    public static String getASDecHome() {
        String dir = ".";
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        dir = dir + "config" + File.separator;
        return dir;
    }

    private static String getReplacementsFile() {
        return Configuration.getASDecHome() + REPLACEMENTS_NAME;
    }

    private static String getConfigFile() {
        return Configuration.getASDecHome() + CONFIG_NAME;
    }

    private static void saveReplacements() {
        try {
            if (replacements.isEmpty()) {
                File rf = new File(Configuration.getReplacementsFile());
                if (rf.exists()) {
                    rf.delete();
                }
            } else {
                File f = new File(Configuration.getASDecHome());
                if (!f.exists()) {
                    f.mkdir();
                }
                PrintWriter pw = new PrintWriter(new FileWriter(Configuration.getReplacementsFile()));
                for (Replacement r : replacements) {
                    pw.println(r.urlPattern);
                    pw.println(r.targetFile);
                }
                pw.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadReplacements() {
        replacements = new ArrayList<Replacement>();
        try {
            String s;
            BufferedReader br = new BufferedReader(new FileReader(Configuration.getReplacementsFile()));
            while ((s = br.readLine()) != null) {
                Replacement r = new Replacement(s, br.readLine());
                replacements.add(r);
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Object getConfig(String cfg) {
        return Configuration.getConfig(cfg, null);
    }

    public static Object getConfig(String cfg, Object defaultValue) {
        if (!config.containsKey(cfg)) {
            return defaultValue;
        }
        return config.get(cfg);
    }

    public static Object setConfig(String cfg, Object value) {
        return config.put(cfg, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(Configuration.getConfigFile()));
            config = (HashMap)ois.readObject();
        }
        catch (FileNotFoundException ex) {
        }
        catch (ClassNotFoundException cnf) {
        }
        catch (IOException ex) {
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException ex1) {}
            }
        }
        Configuration.loadReplacements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        File f = new File(Configuration.getASDecHome());
        if (!f.exists()) {
            f.mkdir();
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(Configuration.getConfigFile()));
            oos.writeObject(config);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(null, "Cannot save configuration.\nPlease make application directory writable.", "Error", 0);
            Logger.getLogger(SWFInputStream.class.getName()).severe("Configuration directory is read only.");
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
        Configuration.saveReplacements();
    }

    public static List<Replacement> getReplacements() {
        return replacements;
    }
}

