/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsIFocusManager;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class MozillaDelegate {
    Browser browser;
    Vector childWindows = new Vector(9);
    static int MozillaProc;
    static Callback SubclassProc;
    static /* synthetic */ Class class$0;

    MozillaDelegate(Browser browser) {
        this.browser = browser;
    }

    static Browser findBrowser(int n) {
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(n);
    }

    static String getCacheParentPath() {
        TCHAR tCHAR = new TCHAR(0, 260);
        if (OS.SHGetFolderPath(0, 28, 0, 0, tCHAR) == 0) {
            return String.valueOf(tCHAR.toString(0, tCHAR.strlen())) + Mozilla.SEPARATOR_OS + "eclipse";
        }
        return MozillaDelegate.getProfilePath();
    }

    static String getJSLibraryName() {
        return "mozjs.dll";
    }

    static String getJSLibraryName_Pre4() {
        return "js3250.dll";
    }

    static String getLibraryName() {
        return "xpcom.dll";
    }

    static String getProfilePath() {
        TCHAR tCHAR = new TCHAR(0, 260);
        String string = OS.SHGetFolderPath(0, 26, 0, 0, tCHAR) == 0 ? tCHAR.toString(0, tCHAR.strlen()) : System.getProperty("user.home");
        return String.valueOf(string) + Mozilla.SEPARATOR_OS + "Mozilla" + Mozilla.SEPARATOR_OS + "eclipse";
    }

    static String getSWTInitLibraryName() {
        return "swt-xulrunner";
    }

    static void loadAdditionalLibraries(String string) {
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        char[] cArray = new char[byArray.length];
        int n = OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
        if (n == cArray.length) {
            return cArray;
        }
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, n);
        return cArray2;
    }

    static boolean needsSpinup() {
        return false;
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        char[] cArray = new char[string2.length()];
        string2.getChars(0, cArray.length, cArray, 0);
        int n = cArray.length * 2 + (bl ? 1 : 0);
        byte[] byArray = new byte[n];
        n = OS.WideCharToMultiByte(0, 0, cArray, cArray.length, byArray, n, null, null);
        if (bl) {
            ++n;
        } else if (byArray.length != n) {
            byte[] byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
            byArray = byArray2;
        }
        return byArray;
    }

    static int windowProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 20: {
                RECT rECT = new RECT();
                OS.GetClientRect(n, rECT);
                OS.FillRect(n3, rECT, OS.GetSysColorBrush(OS.COLOR_WINDOW));
            }
        }
        return OS.CallWindowProc(MozillaProc, n, n2, n3, n4);
    }

    void addWindowSubclass() {
        int n = OS.GetWindow(this.browser.handle, 5);
        if (SubclassProc == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.swt.browser.MozillaDelegate");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            SubclassProc = new Callback(clazz, "windowProc", 4);
            MozillaProc = OS.GetWindowLongPtr(n, -4);
        }
        OS.SetWindowLongPtr(n, -4, SubclassProc.getAddress());
    }

    int createBaseWindow(nsIBaseWindow nsIBaseWindow2) {
        return nsIBaseWindow2.Create();
    }

    int getHandle() {
        return this.browser.handle;
    }

    int getSiteWindow() {
        if (Mozilla.IsPre_4 || Mozilla.IsGettingSiteWindow) {
            return this.getHandle();
        }
        Composite composite = new Composite(this.browser, 0);
        this.childWindows.addElement(composite);
        return composite.handle;
    }

    void handleFocus() {
    }

    void handleMouseDown() {
    }

    boolean hookEnterExit() {
        return true;
    }

    void init() {
        if (!Mozilla.IsPre_4) {
            this.browser.addListener(31, new Listener(){

                public void handleEvent(Event event) {
                    if ((event.detail & 0x18) == 0) {
                        return;
                    }
                    int[] nArray = new int[1];
                    int n = XPCOM.NS_GetServiceManager(nArray);
                    if (n != 0) {
                        Mozilla.error(n);
                    }
                    if (nArray[0] == 0) {
                        Mozilla.error(-2147467262);
                    }
                    nsIServiceManager nsIServiceManager2 = new nsIServiceManager(nArray[0]);
                    nArray[0] = 0;
                    byte[] byArray = MozillaDelegate.wcsToMbcs(null, "@mozilla.org/focus-manager;1", true);
                    n = nsIServiceManager2.GetServiceByContractID(byArray, nsIFocusManager.NS_IFOCUSMANAGER_10_IID, nArray);
                    nsIServiceManager2.Release();
                    if (n == 0 && nArray[0] != 0) {
                        nsIFocusManager nsIFocusManager2 = new nsIFocusManager(nArray[0]);
                        nArray[0] = 0;
                        n = nsIFocusManager2.GetFocusedElement(nArray);
                        nsIFocusManager2.Release();
                        boolean bl = event.doit = nArray[0] == 0;
                        if (n == 0 && nArray[0] != 0) {
                            new nsISupports(nArray[0]).Release();
                        }
                    }
                }
            });
            this.browser.addLocationListener(new LocationAdapter(){

                public void changing(LocationEvent locationEvent) {
                    Enumeration enumeration = MozillaDelegate.this.childWindows.elements();
                    while (enumeration.hasMoreElements()) {
                        ((Composite)enumeration.nextElement()).dispose();
                    }
                    MozillaDelegate.this.childWindows.clear();
                }
            });
        }
    }

    void onDispose(int n) {
        this.removeWindowSubclass();
        this.childWindows = null;
        this.browser = null;
    }

    void removeWindowSubclass() {
        if (SubclassProc == null) {
            return;
        }
        int n = OS.GetWindow(this.browser.handle, 5);
        OS.SetWindowLongPtr(n, -4, MozillaProc);
    }

    boolean sendTraverse() {
        return false;
    }

    void setSize(int n, int n2, int n3) {
    }
}

