#
# fl0p - fingerprint database
# ---------------------------
#
# Entries in this file specify fingerprints for various types of 
# client-server traffic. The parameters examined by the program are:
#
# * Protocol used for the session (currently supported: TCP, UDP, ICMP),
#
# * The direction of each packet (we check whether it was sent from 
#   client to server, or vice versa),
#
# * The size of layer 7 payload that rides on top of each of the packets,
# 
# * The delay between packets, if exceeds a certain threshold 
#   (default: 500 ms), indicative of more extensive I/O, asynchronous
#   events, or user input,
#
# * Session boundaries, if applicable.
#
# ===========================
# BASIC SIGNATURE INFORMATION
# ===========================
#
# A raw signature produced by fl0p will look like this:
#
#   c40 s27 c146 + s146 c0 ...
#
# Words beginning with 'c' denote client-originating packets, and
# 's' stands for server; '+' denotes a delay that exceeds 500 ms
# (or whatever was specified using the -t command line switch).
#
# To build a good signature (fl0p -U), one first needs to run a couple
# of tests: initiate the same type of traffic from/to various hosts,
# using various accounts and settings, and see how the signatures
# would differ, which part of it is best used as a fixed, but 
# sufficiently long and unique identifying block - and once this is
# established, the signature needs to be added to this file. The
# basic format is as follows:
#
# proto ( port | * ) [ = ] [ < ] signature [ > ] : description
#
# Where 'proto' can be 'tcp', 'udp', 'icmp'; port can be a specific
# port number if you want to restrict a rule only to a known protocol
# (for example, HTTPS inspection), or it can be '*' (best); 'signature'
# is a copy of the previously chosen identifying block, and
# 'description' is a short text, such as 'Null SSH probe' or
# 'Human SMTP interaction'.
#
# ====================
# RANGES AND WILDCARDS
# ====================
#
# In some cases, it might be desirable to allow certain packet sizes
# to vary. If a numerical value is replaced by '*', any packet size
# will match; if a numerical value is immediately followed by ':nn',
# for example C40:10, a margin of +/- nn (10) will be allowed while
# matching that packet. Using margins of 10-20% usually enables
# signatures to match encapsulated traffic with no major side
# effects; additionally, it is always recommended to use broad upper
# margins for packet sizes that get close to MSS (MTU-40), otherwise
# signatures may be useless for other source hosts and network links.
# fl0p supports automatic MTU matching when '$' is specified
# instead of a value (it is technically equivalent to 1075/625,
# wildcarding a range of packet sizes from 450 to 1700).
#
# ============================
# BACK- AND FORWARD-REFERENCES
# ============================
#
# The other feature supported by fl0p are back- and forward-references
# in packet sizes. When no clear fixed pattern can be established, but
# a defining feature of a protocol is that certain packets follow
# each other's sizes (for example, exchanged session keys, etc), one
# can use @ modifier (S@rr, C@rr, S@rr:nn...) to make a reference
# to a chosen packet within the signature (numbered from 1, from the
# left).
#
# Signature matching can be constrained by using a '=' keyword
# immediately after protocol specification (for example, 'TCP = C40...').
# This disables fuzzy matching on the signature: fl0p will not try
# to detect encapsulation by checking for this signature within
# other protocols, with client and server roles reversed, etc.
#
# Last but not least, a signature that strives to be particularly
# pedantic (or is prone to false-positives), can be limited by
# specifying that a session start and/or end must be matched on
# its boundary. This is done by adding a preceeding '<' or closing
# '>' keyword, consequently. For example, this signature:
#
# TCP = < C* S50 : Test
#
# ...will only match traffic where, after the connection is established
# the second packet from the server has a payload of 50 bytes.
#
# Note that fl0p will recommend some sane margins and defaults for
# these values.
#
# ==================
# SIGNATURE CHAINING
# ==================
#
# In addition, starting from 0.0.2, there is an advanced feature that
# allows you to build chained signatures (so that a more complex time
# pattern can be analyzed). First, one needs to define a "silent"
# signature that would set or clear a flag for that particular
# connection; this flag can be then checked within other signatures. 
# This is done the following way:
#
# proto ( port | * ) [ = ] [ < ] rule [ > ] | +0xnnn
# proto ( port | * ) [ = ] [ < ] rule [ > ] | -0xnnn
# 
# ...the difference is that '|' is used instead of ':' as a
# separator, and that a hexadecimal value preceeded either by
# + or - then follows. An internal 32 bit register local to that
# particular stream would then have bits set in the following hex
# number (0xnnn) either set (+0xnnn), or cleared (0xnnn).
#
# All rules can be then additionally checked against this
# register, by adding an extra element in front of the rule:
#
# [ &0xnnn | !0xnnn ] proto ( port | * ) [ = ] [ < ] rule [ > ] ...
#
# Such a rule will only be evaluated when specified flags are
# set (&) or zeroed (!) in the 32-bit register. Subsequent
# silent signatures can be made conditional the same way; as
# such, it is possible to construct a fairly complex system
# of conditional examination for any given stream. A trivial
# example:
#
# tcp * = c1 + c1 + c2 | +0x1
# tcp * = c1 c1 c2 | +0x1
# &0x1 tcp * = c1 c1 c2 : Repeated key-by-key typing patterns (1)
# &0x1 tcp * = c1 + c1 + c2 : Repeated key-by-key-typing patterns (2)
#
# NOTE: Directives such as =, < and > must be separate words;
# on the other hand, flag check/set data, and packet size
# counts, must have no spaces inside.
#

# SSH v1 signatures, based on OpenSSH client/server:
tcp * = < s27/15 c27/15 s270/10 > : SSH1 - client chose to refuse server key
tcp * = < s27/15 c27/15 s270/10 + c150/20 s12 c30/10 s@5 c@5 s@6 : SSH1 - client manually accepted key
tcp * = < s27/15 c27/15 s270/10 c150/20 s12 c30/10 s@5 c@5 : SSH1 - client had server key
tcp * = < s27/15 c27/15 s270/10 c150/20 s12 c30/10 s@5 c@5 s28/4 > : SSH1 - null session
tcp * = s12 c@1 s28 + c52 s@1 c@1 s@3 : SSH1 - invalid password attempt
tcp * = s12 c@1 s28 + c52 s@1 c140/20 s@1 : SSH1 - correct password
tcp * = s12 c@1 s28 c52 s@1 c@1 s@3 : SSH1 - automated password guessing?

# Some ancient clients / server combos:
tcp * = < s27/15 c27/15 s270/10 c150/10 s12 c28 s12 + c40/20 s12 : SSH1 - invalid password attempt (ancient)
tcp * = < s27/15 c27/15 s270/10 c150/10 s12 c28 s12 + c40/20 s12 c150/10 c12 : SSH1 - correct password (ancient)
tcp * = < s27/15 c27/15 s270/10 c150/10 s12 c28 s12 c40/20 s12 s@5 : SSH1 - automated password guessing? (ancient)

# SSH v2 signatures, based on OpenSSH client/server:
tcp * = < s27/15 c27/15 s$ c$ c24 s150/10 c144 s$ > : SSH2 - client chose to refuse key
tcp * = < s27/15 c27/15 s$ c$ c24 s150/10 c144 s$ + c16 c48 : SSH2 - client manually accepted key
tcp * = < s27/15 c27/15 s$ c$ c24 s150/10 c144 s$ c16 c48 : SSH2 - client had server key
tcp * = < s27/15 c27/15 s$ c$ c24 s150/10 c144 s$ c16 c48 s@10 c80 s@12 c96 s64 > : SSH2 - null session
tcp * = s$ c16 c48 s@3 c70/15 s80 c96 s64 + c@6 s@6 c@7 s@8 : SSH2 - invalid password attempt
tcp * = s$ c16 c48 s@3 c70/15 s80 c96 s64 + c@6 s@3 c@6 s32 : SSH2 - correct password
tcp * = s$ c16 c48 s@3 c70/15 s80 c96 s64 c@6 s@6 c@7 s@8 : SSH2 - automated password guessing?

# PuTTY (to be done)
tcp * = < s27/15 c27/15 s$ c$ c16 s400/50 + c400/50 + s$ + c16 c52 s52 : SSH2 - PuTTY 
tcp * = s12 + c400/20 s@1 c52/10 s@1 c@1 : SSH1 - PuTTY - correct password

# Windows telnet / generalized char-by-char signatures:
tcp * = c1 c1 c2 s30/30 : Possible manual Windows telnet input (1)
tcp * = c30/30 + c1 c1 c1 : Possible manual Windows telnet input (2)
tcp * = s30/30 + c1 + c1 + c1 : Possible manual Windows telnet input (rookie)

&0x1 tcp * = c1 + c1 + c2 : Possible manual Windows telnet input (multi-packet)
tcp * = c1 + c1 + c2 | +0x1

# Other probable manual signatures:
tcp * = < s50/50 + c50/50 s50/50 + c50/50 s50/50 + c50/50 : Possible manual line-by-line interaction

# Weird tunnel behavior:
tcp 443 = c30/30 + c30/30 + c30/30 : SSL - unusual client-server activity

# Weird SMTP behavior:
tcp 25 = < s100/90 c30/25 s100/100 c360/300 : SMTP - possible command flood (1)
tcp 25 = < s100/90 c380/300 : SMTP - possible command flood (2)
tcp 25 = < s100/90 + c10/10 s100/100 + c30/30 s100/100 + c30/30 s100/100 : SMTP - possible human interaction
