# Framework for Internal Navigation and Discovery (FIND3)

<img src="/images/find_logo.png" width="180px" alt="Home"/>

Have you ever wanted to...

- do home automation without motion sensors?
- track your phone or laptop *indoors* without GPS?
- monitor the whereabouts and trajectories of cell phones?

FIND3 is an attempt implement a solution to these questions.

FIND3 is in its early days, but the plan is to develop a **Framework for Internal Navigation and Discovery**.

If you'd like to help us make that vision a reality, we'd love to have you try
out FIND3.

FIND3 is an [open-source project](https://github.com/schollz/find3) that
comprises several main components:


1. Data storage server [(github.com/schollz/find3/server/main)](https://github.com/schollz/find3/tree/master/server/main)
2. Machine learning server [(github.com/schollz/find3/server/ai)](https://github.com/schollz/find3/tree/master/server/ai)
3. Command-line tool for gathering fingerprints [(schollz/find3-cli-scanner)](https://github.com/schollz/find3-cli-scanner)
4. Android app for gathering fingerprints [(schollz/find3-android-scanner)](https://github.com/schollz/find3-android-scanner)


Using these elements as building blocks, FIND3 provides the ability to track devices indoors, without motion sensors.

To get started, read the documentation and take a look at the repo. The easiest way to start is to read [Tracking your phone](/doc/tracking_your_phone.md).

## Documentation

The [Documentation](/doc/doc.md) page holds annotated links to the
rich documentation for FIND3, which includes everything from
user guides to details about the design and implementation.

## Community

FIND3 is an open source project with a growing community
of users and contributors.
These resources support the open source project and
point to things such as the GitHub repository,
mailing lists, user forums, and so on.

- [The FIND3 project on GitHub](https://github.com/schollz/find3)
- [Issue tracker](https://github.com/schollz/find3/issues)
- Official discussion forums / mailing lists:
  - [Slack channel](https://join.slack.com/t/find3/shared_invite/enQtMzU4MjY0NjE1NjU0LWRkY2JhNWFkM2U3Y2JhY2RlZTQ5ZTdmZTQ2M2UzMjI2MGVmMjZlOWQyZmU3MzM5YzIzOTM0YmYzYmQ3NTQzNjQ),
    for discussion FIND3 users and developers.
  - [FIND mailing list](http://eepurl.com/bhfFI1),
    a low-traffic list for important announcements about the project;
    all FIND3 users should subscribe.
- [Contribution guidelines](https://github.com/schollz/find3/blob/master/CONTRIBUTING.md)


