# FHTTP Kit by Xianur0
# Copyright (C) 2011 Oscar García López (http://hackingtelevision.blogspot.com) 
#  
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#   
#    xianur0.null@gmail.com
#    http://hackingtelevision.blogspot.com/

package analizador;
$idioma = &main::mods("--lang");
# Analizador de metodos
sub grafico() {
	my $ventana = Gtk2::Window->new('toplevel');
	$ventana->set_title(dic::titulos($idioma,0));
	$ventana->set_default_icon_from_file("icono.jpg");
	$ventana->set_border_width(5);
	$ventana->set_default_size(20, 20);
	$ventana->set_resizable(FALSE);
	$hbox = Gtk2::VBox->new(0, 0);
	$hbox->set_border_width(5);
	$caja = Gtk2::HBox->new(0,0);
	$etiqueta = Gtk2::Label->new('URL: ');
	$url = Gtk2::Entry->new();
	&main::share($url);
	$caja->pack_start($etiqueta, FALSE,FALSE,2);
	$caja->pack_start($url, FALSE,FALSE,2);
	$boton = Gtk2::Button->new(dic::fingerlabels($idioma,1));
	$boton->signal_connect('clicked' => sub {$threadproxy = threads->create('iniciaranalisis'); });
	$mostrar = Gtk2::Label->new(dic::fingerlabels($idioma,2));
	&main::share($mostrar);
	$imagen = Gtk2::Image->new_from_file("logo.png");
	$hbox->pack_start($imagen, FALSE, FALSE, 2);
	$hbox->pack_start($caja, FALSE, FALSE, 2);
	$hbox->pack_start($boton, FALSE, FALSE, 2);
	$hbox->pack_start($mostrar,FALSE,FALSE,2);
	$hbox->show;
	$ventana->add($hbox);
	$ventana->show_all;
	Gtk2->main;
}

sub new {
	if(&main::mods("Gtk2") == 1) {
		grafico();
	} else {
		
		iniciaranalisis();
	}
}

sub iniciaranalisis {
my @encabezadoss = ("User-Agent: Mozilla/5.0 (X11; U; Linux i686; es-ES; rv:1.9.1.8) Gecko/20100214 Ubuntu/9.10 (karmic) Firefox/3.5.8");
$mostrar->set_text(dic::mensajes($idioma,5)."...\n") if(&main::mods("Gtk2") == 1);
my $puerto = 80;
my $path = "/";
my $ssl = 0;
my $host = "";
my $hostenvio = "";
my $puertoenvio = "";
my $resto = "";
my $scheme = "";
my $urlactual = ((&main::mods("Gtk2") == 1) ? $url->get_text : $ARGV[1]);
die(dic::comunes($idioma,0).": fhttp.pl 2 [url]\n") if($urlactual !~ /^http/);
($scheme,$resto) = ($urlactual =~ /^(https?):\/\/(.*)/);
$ssl = 1 if($scheme eq "https");
print "SSL: ".$ssl."\n";
if($resto =~ /(.*?)\/(.*)/) {
	$path = "/".$2;
	$resto = $1;
}
if($resto =~ /(.*?):([\d]*)$/) {
	$host = $1;
	$puerto = $2;
} else {
	$host = $resto;
	$puerto = "443" if($ssl == 1);
}
if(&main::mods("Cheat---proxy") =~ /^([^:]+):(\d+)$/) {
	$hostenvio = $1;
	$puertoenvio = $2;
} else {
	$hostenvio = $host;
	$puertoenvio = $puerto;
}
print dic::mensajes($idioma,6).": ".$hostenvio.":".$puertoenvio."\n\n";
$mostrar->set_text(join "","SSL: ",$ssl,"\n".dic::comunes($idioma,2).": ",$puerto,"\n".dic::comunes($idioma,3).": ",$host,"\n".dic::comunes($idioma,4).": ",$path,"\n") if(&main::mods("Gtk2") == 1);
if(($puerto != 80 && $ssl == 0) || (($puerto != 443 || $puerto ne "https") && $ssl == 1)) {
$lineaurl = join "",$scheme,"://",$host,":",$puerto,$path;
} else {
$lineaurl = join "",$scheme,"://",$host,$path;
}
$mostrar->set_text(join "",dic::mensajes($idioma,5),": ",$urlactual,"\n") if(&main::mods("Gtk2") == 1);

my $textomostrarfinal = "";
print &main::red, "[-] ".dic::mensajes($idioma,5)."...\n", &main::reset;
# Enviamos un Expected
my $paquete = http->new("GET",$lineaurl,"1.1");
$paquete->agregarencabezados(0,@encabezadoss);
$paquete->agregarencabezados(0,("Expected: <script>alert(/xss/.source)</script>","Connection: Close\r\nProxy-Connection: Close\r\n"));
$paquete->print;
%estructura = $paquete->enviar($hostenvio,$puertoenvio,$ssl);
if($estructura{contenidos}[0] =~ /<script>alert\(\/xss\/\.source\)<\/script>/) {
print &main::red, dic::comunes($idioma,8),":\n", $reset;
print $estructura{contenidos}[0]."\n\n";
$textomostrarfinal .= dic::mensajes($idioma,16)." \"Expected\"!\n";
}

# Enviamos TRACE
my $paquete = http->new("TRACE",$lineaurl,"1.0");
$paquete->agregarencabezados(0,("X: <script>alert(/xss/.source)</script>"));
$paquete->print;
%estructura = $paquete->enviar($hostenvio,$puertoenvio,$ssl);
if($estructura{contenidos}[0] =~ /<script>alert\(\/xss\/\.source\)<\/script>/) {
print &main::red, dic::comunes($idioma,8),":\n", $reset;
print $estructura{contenidos}[0]."\n\n";
$textomostrarfinal .= "XST!\n";
}

# Enviamos PUT
my $esquema = "http://";
$esquema = "https://" if($ssl == 1);
if($puerto != 80) {
$urlput = join "",$esquema,$host,":",$puerto,"/hacked.txt";
} else {
$urlput = join "",$esquema,$host,"/hacked.txt";
}
my $paquete = http->new("PUT",$urlput,"1.1");
$paquete->agregarencabezados(0,@encabezadoss);
$paquete->agregarencabezados(0,("Connection: Close\r\nProxy-Connection: Close\r\n"));
$paquete->establecercontenido(0,"Vulnerable a PUT");
$paquete->print;
%estructura = $paquete->enviar($hostenvio,$puertoenvio,$ssl);
my $paquete = http->new("PUT",$urlput,"1.0");
$paquete->agregarencabezados(0,@encabezadoss);
$paquete->establecercontenido(0,"Vulnerable a PUT");
$paquete->print;
%estructura = $paquete->enviar($hostenvio,$puertoenvio,$ssl);

# Comprobamos el PUT y probamos el CONNECT
my $paquete = http->new("GET",$urlput,"1.1");
$paquete->agregarencabezados(0,@encabezadoss);
$paquete->agregarencabezados(0,("Connection: Close\r\nProxy-Connection: Close\r\n"));
$paquete->modo(1);
%estructura = $paquete->enviar($hostenvio,$puertoenvio,$ssl);
if($estructura{contenidos}[0] =~ /Vulnerable a PUT/) {
$textomostrarfinal .= join "",dic::mensajes($idioma,17),"\n\tURL: ",$urlput,"\n";
}
my $paquete = http->new("CONNECT","mail.google.com:443","1.0",1);
$paquete->print;
%estructura = $paquete->enviar($hostenvio,$puertoenvio,$ssl);
if($estructura{estados}[0] =~ /HTTP\/1\.(0|1) 200 Connection established/) {
print &main::red, dic::mensajes($idioma,18),":\n", $reset;
print $estructura{estados}[0]."\n\n";
$textomostrarfinal .= dic::mensajes($idioma,19)."!\n";
}
$textomostrarfinal = dic::mensajes($idioma,20)."\n" if($textomostrarfinal eq "");
print &main::red,dic::comunes($idioma,11),":\n",&main::reset,$textomostrarfinal."\n";
$mostrar->set_text(dic::comunes($idioma,11).":\n".$textomostrarfinal) if(&main::mods("Gtk2") == 1);
}
# /analizador de metodos


1;
