/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.ListStack;

public class StrongConnectivityHelper {
    private final List<List<Statement>> components = new ArrayList<List<Statement>>();
    private final Set<Statement> setProcessed = new HashSet<Statement>();
    private final ListStack<Statement> component = new ListStack();
    private final Set<Statement> visited = new HashSet<Statement>();
    private final Map<Statement, Integer> indices = new HashMap<Statement, Integer>();
    private final Map<Statement, Integer> lowIndices = new HashMap<Statement, Integer>();
    private int nextIndex;

    public StrongConnectivityHelper(@NotNull Statement startStatement) {
        this.visitTree(startStatement.getFirst());
        for (Statement statement : startStatement.getStats()) {
            if (this.setProcessed.contains(statement) || !statement.getPredecessorEdges(StatEdge.EdgeType.DIRECT_ALL).isEmpty()) continue;
            this.visitTree(statement);
        }
        for (Statement statement : startStatement.getStats()) {
            if (this.setProcessed.contains(statement)) continue;
            this.visitTree(statement);
        }
    }

    private void visitTree(@NotNull Statement statement) {
        this.component.clear();
        this.visited.clear();
        this.indices.clear();
        this.lowIndices.clear();
        this.nextIndex = 0;
        this.visit(statement);
        this.setProcessed.addAll(this.visited);
        this.setProcessed.add(statement);
    }

    private void visit(@NotNull Statement statement) {
        this.component.push(statement);
        this.indices.put(statement, this.nextIndex);
        this.lowIndices.put(statement, this.nextIndex);
        ++this.nextIndex;
        List<Statement> successors = statement.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.FORWARD);
        successors.removeAll(this.setProcessed);
        for (Statement successor : successors) {
            int successorIndex;
            if (this.visited.contains(successor)) {
                successorIndex = this.indices.get(successor);
            } else {
                this.visited.add(successor);
                this.visit(successor);
                successorIndex = this.lowIndices.get(successor);
            }
            this.lowIndices.put(statement, Math.min(this.lowIndices.get(statement), successorIndex));
        }
        if (this.lowIndices.get(statement).intValue() == this.indices.get(statement).intValue()) {
            Statement statementInComponent;
            ArrayList<Statement> component = new ArrayList<Statement>();
            do {
                statementInComponent = this.component.pop();
                component.add(statementInComponent);
            } while (statementInComponent != statement);
            this.components.add(component);
        }
    }

    public static boolean isExitComponent(@NotNull List<? extends Statement> component) {
        HashSet<Statement> statements = new HashSet<Statement>();
        for (Statement statement : component) {
            statements.addAll(statement.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.FORWARD));
        }
        for (Statement statement : component) {
            statements.remove(statement);
        }
        return statements.isEmpty();
    }

    @NotNull
    public List<Statement> getExitReps() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (List<Statement> component : this.components) {
            if (!StrongConnectivityHelper.isExitComponent(component)) continue;
            result.add(component.get(0));
        }
        return result;
    }

    @NotNull
    public @NotNull List<@NotNull List<Statement>> getComponents() {
        return this.components;
    }
}

