"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Config = _interopRequireDefault(require("./Config"));

var _Default = _interopRequireDefault(require("./Strategies/Default"));

var _Deterministic = _interopRequireDefault(require("./Strategies/Deterministic"));

var _Random = _interopRequireDefault(require("./Strategies/Random"));

var _BucketsDeterministic = _interopRequireDefault(require("./Strategies/BucketsDeterministic"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var _default = function () {
  var strat = _Config["default"].testStrategy;

  switch (strat) {
    case "default":
      return _Default["default"];

    case "deterministic":
      return _Deterministic["default"];

    case "buckets_deterministic":
      return _BucketsDeterministic["default"];

    case "random":
      return _Random["default"];

    default:
      throw "Strategy Error";
  }
}();

exports["default"] = _default;