"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _child_process = require("child_process");

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var tmp = require("tmp");

var fs = require("fs");

var _kill = require("tree-kill");

var EXPOSE_REPLAY_PATH = "expoSE replay";

var Spawn = /*#__PURE__*/function () {
  function Spawn(script, file, opts) {
    _classCallCheck(this, Spawn);

    this.script = script;
    this.file = file;
    this.options = opts;
    this.args = [this.file.path, JSON.stringify(this.file.input)];
    this.tmpCoverageFile = tmp.fileSync();
    this.tmpOutFile = tmp.fileSync();
    this.env = JSON.parse(JSON.stringify(process.env));
    this.env.EXPOSE_OUT_PATH = this.tmpOutFile.name;
    this.env.EXPOSE_COVERAGE_PATH = this.tmpCoverageFile.name;
  }

  _createClass(Spawn, [{
    key: "_tryParse",
    value: function _tryParse(data, type, errors) {
      try {
        return JSON.parse(data);
      } catch (e) {
        errors.push({
          error: "Exception E: " + e + " of " + type + " on " + data
        });
        return null;
      }
    }
  }, {
    key: "startTime",
    value: function startTime() {
      return this._startTime;
    }
  }, {
    key: "endTime",
    value: function endTime() {
      return this._endTime;
    }
  }, {
    key: "time",
    value: function time() {
      return this._endTime - this._startTime;
    }
  }, {
    key: "_recordEndTime",
    value: function _recordEndTime() {
      this._endTime = Date.now();
    }
  }, {
    key: "_processEnded",
    value: function _processEnded(code, done) {
      this._recordEndTime();

      var me = this;
      var errors = [];
      var coverage = null;
      var finalOut = null;
      var count = 0;
      var test = this;

      function cb(err) {
        count++;

        if (err) {
          errors.push({
            error: err
          });
        }

        if (count == 2) {
          test.tmpOutFile.removeCallback();
          test.tmpCoverageFile.removeCallback();
          done(me, code, test, finalOut, coverage, errors);
        }
      }

      fs.readFile(this.tmpOutFile.name, {
        encoding: "utf8"
      }, function (err, data) {
        if (!err) {
          finalOut = test._tryParse(data, "test data", errors);
        }

        cb(err);
      });
      fs.readFile(this.tmpCoverageFile.name, {
        encoding: "utf8"
      }, function (err, data) {
        if (!err) {
          coverage = test._tryParse(data, "coverage data", errors);
        }

        cb(err);
      });
    }
  }, {
    key: "shellescape",
    value: function shellescape(a) {
      var ret = [];
      a.forEach(function (s) {
        if (/[^A-Za-z0-9_\/:=-]/.test(s)) {
          s = "'" + s.replace(/'/g, "'\\''") + "'";
        }

        ret.push(s);
      });
      return ret.join(" ");
    }
  }, {
    key: "_mkEnvReplay",
    value: function _mkEnvReplay() {
      var envStr = "";

      for (var i in this.env) {
        envStr += i + "=\"" + this.env[i] + "\" ";
      }

      return envStr;
    }
  }, {
    key: "makeReplayString",
    value: function makeReplayString() {
      return (
        /* this._mkEnvReplay() + */
        EXPOSE_REPLAY_PATH + " " + this.shellescape(this.args)
      );
    }
  }, {
    key: "kill",
    value: function kill() {
      _kill(this._pid, "SIGKILL");
    }
  }, {
    key: "_buildTimeout",
    value: function _buildTimeout() {
      var _this = this;

      return setTimeout(function () {
        _this.kill();
      }, this.options.timeout);
    }
  }, {
    key: "start",
    value: function start(done) {
      var _this2 = this;

      this._startTime = Date.now();

      try {
        var stdio = this.options.log ? ["ignore", "inherit", "inherit"] : ["ignore", "ignore", "ignore"];
        var prc = (0, _child_process.spawn)(this.script, this.args, {
          stdio: stdio,
          env: this.env,
          disconnected: false
        });
        prc.on("exit", function (code) {
          clearTimeout(_this2._killTimeout);

          _this2._processEnded(code, done);
        });
        this._killTimeout = this._buildTimeout();
        this._pid = prc.pid;
      } catch (ex) {
        console.log("Distributor ERROR: " + ex + " just falling back to default error");

        this._processEnded(99999, done);
      }

      return this;
    }
  }]);

  return Spawn;
}();

var _default = Spawn;
exports["default"] = _default;