"use strict";

var _Internal = _interopRequireDefault(require("./Internal"));

var _Center = _interopRequireDefault(require("./Center"));

var _Config = _interopRequireDefault(require("./Config"));

var _CoverageMap = _interopRequireDefault(require("./CoverageMap"));

var _JsonWriter = _interopRequireDefault(require("./JsonWriter"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* Copyright (c) Royal Holloway, University of London | Contact Blake Loring (blake@parsed.uk), Duncan Mitchell (Duncan.Mitchell.2015@rhul.ac.uk), or Johannes Kinder (johannes.kinder@rhul.ac.uk) for details or support | LICENSE.md for license details */
process.title = "ExpoSE Distributor";
process.on("disconnect", function () {
  console.log("Premature termination - Parent exit");
  process.exit();
});

if (process.argv.length >= 3) {
  var target = process.argv[process.argv.length - 1];
  var initialInput = undefined;

  if (process.argv.length == 4) {
    target = process.argv[process.argv.length - 2];
    initialInput = JSON.parse(process.argv[process.argv.length - 1]);
  }

  console.log("[+] ExpoSE ".concat(target, " concurrent: ").concat(_Config["default"].maxConcurrent, " timeout: ").concat(_Config["default"].maxTime, " per-test: ").concat(_Config["default"].testMaxTime));
  var start = new Date().getTime();
  var center = new _Center["default"](_Config["default"]);
  process.on("SIGINT", function () {
    center.cancel();
  });
  var maxTimeout = setTimeout(function () {
    center.cancel();
  }, _Config["default"].maxTime);
  center.done(function (center, done, errors, coverage, stats) {
    if (_Config["default"].jsonOut) {
      console.log("Writing JSON");
      (0, _JsonWriter["default"])(_Config["default"].jsonOut, target, coverage, start, new Date().getTime(), done);
    }

    function round(num, precision) {
      return Math.round(num * Math.pow(10, precision)) / Math.pow(10, precision);
    }

    function formatSeconds(v) {
      return round(v / 1000, 4);
    }

    console.log("");
    done.forEach(function (item) {
      var pcPart = _Config["default"].printPathCondition ? " PC: ".concat(item.pc) : "";
      console.log("[+] ".concat(JSON.stringify(item.input)).concat(pcPart, " took ").concat(formatSeconds(item.time), "s"));
      item.errors.forEach(function (error) {
        return console.log("[!] ".concat(error.error));
      });

      if (item.errors.length != 0) {
        console.log("[!] ".concat(item.replay));
      }
    });
    console.log("[!] Stats");

    for (var stat in stats) {
      console.log("[+] ".concat(stat, ": ").concat(JSON.stringify(stats[stat].payload)));
    }

    console.log("[!] Done");
    var totalLines = 0;
    var totalRealLines = 0;
    var totalLinesFound = 0;
    coverage["final"]().forEach(function (d) {
      if ((0, _Internal["default"])(d.file)) {
        return;
      }

      console.log("[+] ".concat(d.file, ". Coverage (Term): ").concat(Math.round(d.terms.coverage * 100), "% Coverage (Decisions): ").concat(Math.round(d.decisions.coverage * 100), "% Coverage (LOC): ").concat(Math.round(d.loc.coverage * 100), "% Lines Of Code: ").concat(d.loc.total, " -*"));
      totalLines += d.loc.total;
      totalRealLines += d.loc.all.length;
      totalLinesFound += d.loc.found;
    });
    Math.round(totalLinesFound / totalRealLines * 10000) / 100;
    console.log("[+] Total Lines Of Code ".concat(totalLines));
    console.log("[+] Total Coverage: ".concat(totalLinesFound / totalRealLines, "%"));

    if (_Config["default"].printDeltaCoverage) {
      (0, _CoverageMap["default"])(coverage.lines(), function (line) {
        return console.log(line);
      });
    } else {
      console.log("[+] EXPOSE_PRINT_COVERAGE=1 for line by line breakdown");
    }

    console.log("[+] ExpoSE Finished. ".concat(done.length, " paths, ").concat(errors, " errors"));
    process.exitCode = errors;
    clearTimeout(maxTimeout);
  }).start(target, initialInput);
} else {
  console.log("USAGE: ".concat(process.argv[0], " ").concat(process.argv[1], " target (Optional: initial input)"));
}