"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _Spawn = _interopRequireDefault(require("./Spawn"));

var _Strategies = _interopRequireDefault(require("./Strategies"));

var _CoverageAggregator = _interopRequireDefault(require("./CoverageAggregator"));

var _Stats = _interopRequireDefault(require("Stats"));

var _Log = _interopRequireDefault(require("./Log"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

var Center = /*#__PURE__*/function () {
  function Center(options) {
    _classCallCheck(this, Center);

    this.cbs = [];
    this._cancelled = false;
    this.options = options;
  }

  _createClass(Center, [{
    key: "start",
    value: function start(file, baseInput) {
      this._lastid = 0;
      this._done = [];
      this._errors = 0;
      this._running = [];
      this._coverage = new _CoverageAggregator["default"]();
      this._stats = new _Stats["default"]();

      this._startTesting([{
        id: this._nextID(),
        path: file,
        input: baseInput || {
          _bound: 0
        }
      }]);

      return this;
    }
  }, {
    key: "done",
    value: function done(cb) {
      this.cbs.push(cb);
      return this;
    }
  }, {
    key: "_startTesting",
    value: function _startTesting(cases) {
      var _this = this;

      this._strategy = new _Strategies["default"]();
      cases.forEach(function (i) {
        return _this._strategy.add(i);
      });

      this._requeue();

      this._printStatus();
    }
    /**
        * If there is a slot & under max paths start an additional test
        */

  }, {
    key: "_startNext",
    value: function _startNext() {
      if (this._strategy.length()) {
        this._testFile(this._strategy.next());
      }
    }
    /**
        * True if another test can begin
        */

  }, {
    key: "_canStart",
    value: function _canStart() {
      return !this._cancelled && this._running.length < this.options.maxConcurrent;
    }
    /**
        * Queue as many tests as possible
        */

  }, {
    key: "_requeue",
    value: function _requeue() {
      while (this._strategy.length() && this._canStart()) {
        this._startNext();
      }
    }
  }, {
    key: "_remove",
    value: function _remove(test) {
      var idx = this._running.indexOf(test);

      if (idx != -1) {
        this._running.splice(idx, 1);
      }
    }
  }, {
    key: "_postTest",
    value: function _postTest(test) {
      this._remove(test); //Start any remaining queued


      this._requeue();

      this._printStatus(); //If finished print output


      if (!this._running.length) {
        this._finishedTesting();
      }
    }
  }, {
    key: "_printStatus",
    value: function _printStatus() {
      (0, _Log["default"])("[" + this._done.length + " done /" + this._strategy.length() + " queued / " + this._running.length + " running / " + this._errors + " errors / " + this._coverage.current().loc.toFixed(2) * 100 + "% coverage ] ***");
    }
  }, {
    key: "_finishedTesting",
    value: function _finishedTesting() {
      var _this2 = this;

      this.cbs.forEach(function (cb) {
        return cb(_this2, _this2._done, _this2._errors, _this2._coverage, _this2._stats["final"]());
      });
    }
  }, {
    key: "cancel",
    value: function cancel() {
      this._cancelled = true;

      this._running.forEach(function (test) {
        return test.kill();
      });

      this._finishedTesting();
    }
  }, {
    key: "_nextID",
    value: function _nextID() {
      return this._lastid++;
    }
  }, {
    key: "_expandAlternatives",
    value: function _expandAlternatives(file, alternatives, testCoverage) {
      var _this3 = this;

      alternatives.forEach(function (alt) {
        _this3._strategy.add({
          id: _this3._nextID(),
          path: file.path,
          input: alt.input,
          pc: alt.pc
        }, alt, testCoverage);
      });
    }
  }, {
    key: "_pushDone",
    value: function _pushDone(test, input, pc, alternatives, coverage, errors) {
      this._done.push({
        id: test.file.id,
        input: input,
        pc: pc,
        errors: errors,
        time: test.time(),
        startTime: test.startTime(),
        coverage: this._coverage.current(),
        case_coverage: this.options.perCaseCoverage ? new _CoverageAggregator["default"]().add(coverage)["final"](true) : undefined,
        replay: test.makeReplayString(),
        alternatives: alternatives.length
      });

      if (errors.length) {
        this._errors += 1;
      }
    }
  }, {
    key: "_testFileDone",
    value: function _testFileDone(spawn, code, test, finalOut, coverage, fsErrors) {
      var errors = fsErrors;

      if (code != 0) {
        errors.push({
          error: "Exit code non-zero"
        });
      }

      if (coverage) {
        this._coverage.add(coverage);
      }

      if (finalOut) {
        this._pushDone(test, finalOut.input, finalOut.pc, finalOut.alternatives, coverage, errors.concat(finalOut.errors));

        this._expandAlternatives(test.file, finalOut.alternatives, coverage);

        this._stats.merge(finalOut.stats);
      } else {
        this._pushDone(test, test.file.input, test.file.pc, [], coverage, errors.concat([{
          error: "Error extracting final output - a fatal error must have occured"
        }]));
      }

      this._postTest(test);
    }
  }, {
    key: "_testFile",
    value: function _testFile(file) {
      var nextTest = new _Spawn["default"](this.options.analyseScript, file, {
        log: this.options.printPaths,
        timeout: this.options.testMaxTime
      });

      this._running.push(nextTest.start(this._testFileDone.bind(this)));

      this._printStatus();
    }
  }]);

  return Center;
}();

var _default = Center;
exports["default"] = _default;