"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _NotAnErrorException = _interopRequireDefault(require("../NotAnErrorException"));

var _IsNative = require("../Utilities/IsNative");

var _WrappedValue = require("../Values/WrappedValue");

var _Helpers = _interopRequireDefault(require("./Helpers"));

var _MathModels = _interopRequireDefault(require("./MathModels"));

var _ArrayModels = _interopRequireDefault(require("./ArrayModels"));

var _StringModels = _interopRequireDefault(require("./StringModels"));

var _FnModels = _interopRequireDefault(require("./FnModels"));

var _RegexModels = _interopRequireDefault(require("./RegexModels"));

var _DOMModels = _interopRequireDefault(require("./DOMModels"));

var _JSONModels = _interopRequireDefault(require("./JSONModels"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/* Copyright (c) Royal Holloway, University of London | Contact Blake Loring (blake@parsed.uk), Duncan Mitchell (Duncan.Mitchell.2015@rhul.ac.uk), or Johannes Kinder (johannes.kinder@rhul.ac.uk) for details or support | LICENSE.md for license details */
function Model() {
  this._models = [];

  this.add = function (fn, _mdl) {
    this._models.push({
      fn: fn,
      mdl: function mdl() {
        return _mdl.call(null, this, arguments);
      }
    });
  };

  this.get = function (fn) {
    var found = this._models.find(function (x) {
      return x.fn == fn;
    });

    return found ? found.mdl : null;
  };
}
/**
 * Builds a set of function models bound to a given SymbolicState
 */


function BuildModels(state) {
  var ctx = state.ctx;
  var model = new Model();
  var helpers = (0, _Helpers["default"])(state, ctx, model);
  (0, _MathModels["default"])(state, ctx, model, helpers);
  (0, _StringModels["default"])(state, ctx, model, helpers);
  (0, _RegexModels["default"])(state, ctx, model, helpers);
  (0, _ArrayModels["default"])(state, ctx, model, helpers);
  (0, _FnModels["default"])(state, ctx, model, helpers);
  (0, _DOMModels["default"])(state, ctx, model, helpers);
  (0, _JSONModels["default"])(state, ctx, model, helpers);
  /**
   * Models for methods on Object
   */

  model.add(Object, function (base, args) {
    var concrete = state.concretizeCall(Object, base, args, false);
    var result = Object.apply(concrete.base, concrete.args);

    if (!(concrete.args[0] instanceof Object) && state.isSymbolic(args[0])) {
      result = new _WrappedValue.ConcolicValue(result, state.asSymbolic(args[0]));
    }

    return result;
  });
  /**
   * Secret _expose hooks for symbols.js
   */

  Object._expose = {};

  Object._expose.makeSymbolic = function (name, initial) {
    return state.createSymbolicValue(name, initial);
  };

  Object._expose.notAnError = function () {
    return _NotAnErrorException["default"];
  };

  Object._expose.pureSymbol = function (name) {
    return state.createPureSymbol(name);
  };

  return model;
}

var _default = BuildModels;
exports["default"] = _default;