"""capability/__init__.py

Created by Thomas Mangin on 2012-07-17.
Copyright (c) 2009-2017 Exa Networks. All rights reserved.
License: 3-clause BSD. (See the COPYRIGHT file)
"""

# Every Capability should be imported from this file
# as it makes sure that all the registering decorator are run

# flake8: noqa: F401,E261

from __future__ import annotations

from exabgp.bgp.message.open.capability.capability import Capability
from exabgp.bgp.message.open.capability.capabilities import Capabilities
from exabgp.bgp.message.open.capability.negotiated import Negotiated

from exabgp.bgp.message.open.capability.nexthop import NextHop
from exabgp.bgp.message.open.capability.addpath import AddPath
from exabgp.bgp.message.open.capability.asn4 import ASN4
from exabgp.bgp.message.open.capability.graceful import Graceful
from exabgp.bgp.message.open.capability.mp import MultiProtocol
from exabgp.bgp.message.open.capability.ms import MultiSession
from exabgp.bgp.message.open.capability.operational import Operational
from exabgp.bgp.message.open.capability.refresh import RouteRefresh
from exabgp.bgp.message.open.capability.refresh import EnhancedRouteRefresh
from exabgp.bgp.message.open.capability.refresh import REFRESH

# Do not remove this include or unknown capability will not be handled
from exabgp.bgp.message.open.capability.unknown import UnknownCapability

__all__ = [
    'Capability',
    'Capabilities',
    'Negotiated',
    'NextHop',
    'AddPath',
    'ASN4',
    'Graceful',
    'MultiProtocol',
    'MultiSession',
    'Operational',
    'RouteRefresh',
    'EnhancedRouteRefresh',
    'REFRESH',
    'UnknownCapability',
]
