/*
 * Decompiled with CFR 0.152.
 */
package com.mwr.dz;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.mwr.jdiesel.api.DeviceInfo;
import com.mwr.jdiesel.api.connectors.Endpoint;
import com.mwr.jdiesel.api.links.Client;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Agent {
    private static Context context;
    private DeviceInfo device_info;
    private Endpoint endpoint;
    private Client client;
    private String uid;

    public Agent(String host, int port) {
        context = null;
        this.device_info = new DeviceInfo(this.getUID(), Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE);
        this.endpoint = new Endpoint(1, "drozer Server", host, port, false, "", "", "", true);
    }

    public Agent(String host, int port, Context applicationContext) {
        context = applicationContext;
        this.device_info = new DeviceInfo(this.getUID(), Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE);
        this.endpoint = new Endpoint(1, "drozer Server", host, port, false, "", "", "", true);
    }

    public Agent(String host, int port, String packageName, Context systemContext) {
        try {
            context = systemContext.createPackageContext(packageName, 2);
            Log.i((String)"drozer", (String)("Got package context for " + packageName));
        }
        catch (Exception e) {
            Log.e((String)"drozer", (String)("Could not get package context for " + packageName));
            Log.d((String)"drozer", (String)e.getMessage());
        }
        if (context == null) {
            try {
                context = systemContext.getApplicationContext();
                Log.i((String)"drozer", (String)"Got system context");
            }
            catch (Exception e) {
                Log.e((String)"drozer", (String)"Could not get system context");
                Log.d((String)"drozer", (String)e.getMessage());
            }
        }
        this.device_info = new DeviceInfo(this.getUID(), Build.MANUFACTURER, Build.MODEL, Build.VERSION.RELEASE);
        this.endpoint = new Endpoint(1, "drozer Server", host, port, false, "", "", "", true);
    }

    public static void main(String[] args) {
        if (args.length == 2) {
            new Agent(args[0], Integer.parseInt(args[1])).run();
        } else {
            System.out.println("usage: agent.jar host port");
        }
    }

    public static Context getContext() {
        return context;
    }

    public Context getMercuryContext() {
        return context;
    }

    private String createUID() {
        String uid = new BigInteger(64, new SecureRandom()).toString(32);
        File uid_file = new File("uid.txt");
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(uid_file)));
            writer.append(uid);
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return uid;
    }

    public String getUID() {
        if (this.uid == null) {
            this.uid = this.createUID();
        }
        return this.uid;
    }

    public void run() {
        this.client = new Client(this.endpoint, this.device_info);
        this.client.start();
    }
}

