/*
    Copyright (C) 2014-2019 de4dot@gmail.com

    This file is part of dnSpy

    dnSpy is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    dnSpy is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with dnSpy.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace dnSpy.Contracts.ToolBars {
	/// <summary>
	/// Constants
	/// </summary>
	public static class ToolBarConstants {
		/// <summary>Guid of app toolbar</summary>
		public const string APP_TB_GUID = "DCDABF16-B5AF-484F-92FD-E852918BF367";

		/// <summary>Group: App ToolBar: Main, Group: Menu</summary>
		public const string GROUP_APP_TB_MAIN_MENU = "0,03D902EE-D1E3-4F5E-B05C-982F6B3438B3";

		/// <summary>Group: App ToolBar: Main, Group: Back/Forward</summary>
		public const string GROUP_APP_TB_MAIN_NAVIGATION = "1000,CB78D3F7-1CB1-4AC2-BDD2-731805C4DB5D";

		/// <summary>Group: App ToolBar: Main, Group: Open</summary>
		public const string GROUP_APP_TB_MAIN_OPEN = "2000,B9D638D4-E58A-4737-9F3F-47DCDADEDFE9";

		/// <summary>Group: App ToolBar: Main, Group: Language</summary>
		public const string GROUP_APP_TB_MAIN_LANGUAGE = "3000,C94CA2F0-3039-4BDD-BE67-B354E2A36CD6";

		/// <summary>Group: App ToolBar: Main, Group: AsmEditor Undo/Redo</summary>
		public const string GROUP_APP_TB_MAIN_ASMED_UNDO = "4000,6351DBFC-6D8D-4847-B3F2-BC376912B9C2";

		/// <summary>Group: App ToolBar: Main, Group: Debug</summary>
		public const string GROUP_APP_TB_MAIN_DEBUG = "5000,A0AFBC69-B6D1-46FE-96C8-EC380DEBE9AA";

		/// <summary>Group: App ToolBar: Main, Group: Debug / Continue</summary>
		public const string GROUP_APP_TB_MAIN_DEBUG_CONTINUE = "6000,47DB0753-CEB2-4D83-A5F2-4DBCFF108E67";

		/// <summary>Group: App ToolBar: Main, Group: Debug / Step</summary>
		public const string GROUP_APP_TB_MAIN_DEBUG_STEP = "7000,5B9EF354-4FB6-4C7D-A700-80A8BEC7FC52";

		/// <summary>Group: App ToolBar: Main, Group: Search</summary>
		public const string GROUP_APP_TB_MAIN_SEARCH = "8000,F8FB775B-7999-4A48-BE1C-C4314D009715";

		/// <summary>Group: App ToolBar: Main, Group: Full Screen</summary>
		public const string GROUP_APP_TB_MAIN_FULLSCREEN = "1000000,F32C7B0E-B9A6-4435-9C75-3FE653ED02AC";
	}
}
